/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.CatalogLockFactory;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.FileSystemCatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemCatalog.class);
    private final Path warehouse;

    public FileSystemCatalog(FileIO fileIO, Path warehouse) {
        super(fileIO);
        this.warehouse = warehouse;
    }

    public FileSystemCatalog(FileIO fileIO, Path warehouse, Options options) {
        super(fileIO, options);
        this.warehouse = warehouse;
    }

    @Override
    public List<String> listDatabases() {
        return FileSystemCatalog.uncheck(() -> this.listDatabasesInFileSystem(this.warehouse));
    }

    @Override
    protected void createDatabaseImpl(String name, Map<String, String> properties) {
        Path databasePath;
        if (properties.containsKey("location")) {
            throw new IllegalArgumentException("Cannot specify location for a database when using fileSystem catalog.");
        }
        if (!properties.isEmpty()) {
            LOG.warn("Currently filesystem catalog can't store database properties, discard properties: {}", properties);
        }
        if (!FileSystemCatalog.uncheck(() -> this.lambda$createDatabaseImpl$1(databasePath = this.newDatabasePath(name))).booleanValue()) {
            throw new RuntimeException(String.format("Create database location failed, database: %s, location: %s", name, databasePath));
        }
    }

    @Override
    public Database getDatabaseImpl(String name) throws Catalog.DatabaseNotExistException {
        if (!FileSystemCatalog.uncheck(() -> this.fileIO.exists(this.newDatabasePath(name))).booleanValue()) {
            throw new Catalog.DatabaseNotExistException(name);
        }
        return Database.of(name);
    }

    @Override
    protected void dropDatabaseImpl(String name) {
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(this.newDatabasePath(name), true));
    }

    @Override
    protected void alterDatabaseImpl(String name, List<PropertyChange> changes) throws Catalog.DatabaseNotExistException {
        throw new UnsupportedOperationException("Alter database is not supported.");
    }

    @Override
    protected List<String> listTablesImpl(String databaseName) {
        return FileSystemCatalog.uncheck(() -> this.listTablesInFileSystem(this.newDatabasePath(databaseName)));
    }

    @Override
    public TableSchema loadTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        return this.tableSchemaInFileSystem(this.getTableLocation(identifier), identifier.getBranchNameOrDefault()).orElseThrow(() -> new Catalog.TableNotExistException(identifier));
    }

    @Override
    protected void dropTableImpl(Identifier identifier, List<Path> externalPaths) {
        Path path = this.getTableLocation(identifier);
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(path, true));
        for (Path externalPath : externalPaths) {
            FileSystemCatalog.uncheck(() -> this.fileIO.delete(externalPath, true));
        }
    }

    @Override
    public void createTableImpl(Identifier identifier, Schema schema) {
        SchemaManager schemaManager = this.schemaManager(identifier);
        try {
            this.runWithLock(identifier, () -> FileSystemCatalog.uncheck(() -> schemaManager.createTable(schema)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T runWithLock(Identifier identifier, Callable<T> callable) throws Exception {
        Optional<CatalogLockFactory> lockFactory = this.lockFactory();
        try (Lock lock = lockFactory.map(factory2 -> factory2.createLock(this.lockContext().orElse(null))).map(l -> Lock.fromCatalog(l, identifier)).orElseGet(Lock::empty);){
            T t = lock.runWithLock(callable);
            return t;
        }
    }

    private SchemaManager schemaManager(Identifier identifier) {
        Path path = this.getTableLocation(identifier);
        return new SchemaManager(this.fileIO, path, identifier.getBranchNameOrDefault());
    }

    @Override
    public void renameTableImpl(Identifier fromTable, Identifier toTable) {
        Path fromPath = this.getTableLocation(fromTable);
        Path toPath = this.getTableLocation(toTable);
        FileSystemCatalog.uncheck(() -> this.fileIO.rename(fromPath, toPath));
    }

    @Override
    protected void alterTableImpl(Identifier identifier, List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        SchemaManager schemaManager = this.schemaManager(identifier);
        try {
            this.runWithLock(identifier, () -> schemaManager.commitChanges(changes));
        }
        catch (RuntimeException | Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException | Catalog.TableNotExistException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T> T uncheck(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String warehouse() {
        return this.warehouse.toString();
    }

    @Override
    public CatalogLoader catalogLoader() {
        return new FileSystemCatalogLoader(this.fileIO, this.warehouse, this.catalogOptions);
    }

    @Override
    public boolean caseSensitive() {
        return this.catalogOptions.getOptional(CatalogOptions.CASE_SENSITIVE).orElse(true);
    }

    private /* synthetic */ Boolean lambda$createDatabaseImpl$1(Path databasePath) throws Exception {
        return this.fileIO.mkdirs(databasePath);
    }
}

