/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.safe;

import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.memory.BytesUtils;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.utils.Preconditions;

public final class SafeBinaryArray
implements InternalArray {
    private final int size;
    private final byte[] bytes;
    private final int offset;
    private final int elementOffset;

    public SafeBinaryArray(byte[] bytes, int offset) {
        Preconditions.checkArgument(bytes.length > offset + 4);
        int size = BytesUtils.getInt(bytes, offset);
        assert (size >= 0) : "size (" + size + ") should >= 0";
        this.size = size;
        this.bytes = bytes;
        this.offset = offset;
        this.elementOffset = offset + BinaryArray.calculateHeaderInBytes(this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    private int getElementOffset(int ordinal, int elementSize) {
        return this.elementOffset + ordinal * elementSize;
    }

    @Override
    public boolean isNullAt(int pos) {
        byte current = this.bytes[this.offset + 4 + MemorySegmentUtils.byteIndex(pos)];
        return (current & 1 << (pos & 7)) != 0;
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.bytes[this.getElementOffset(pos, 1)] != 0;
    }

    @Override
    public byte getByte(int pos) {
        return this.bytes[this.getElementOffset(pos, 1)];
    }

    @Override
    public short getShort(int pos) {
        int fieldOffset = this.getElementOffset(pos, 2);
        Preconditions.checkArgument(this.bytes.length >= fieldOffset + 2);
        return BytesUtils.getShort(this.bytes, fieldOffset);
    }

    @Override
    public int getInt(int pos) {
        int fieldOffset = this.getElementOffset(pos, 4);
        Preconditions.checkArgument(this.bytes.length >= fieldOffset + 4);
        return BytesUtils.getInt(this.bytes, fieldOffset);
    }

    @Override
    public long getLong(int pos) {
        int fieldOffset = this.getElementOffset(pos, 8);
        Preconditions.checkArgument(this.bytes.length >= fieldOffset + 8);
        return BytesUtils.getLong(this.bytes, fieldOffset);
    }

    @Override
    public float getFloat(int pos) {
        return Float.intBitsToFloat(this.getInt(pos));
    }

    @Override
    public double getDouble(int pos) {
        return Double.longBitsToDouble(this.getLong(pos));
    }

    @Override
    public BinaryString getString(int pos) {
        return BinaryString.fromBytes(this.getBinary(pos));
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        long longValue = this.getLong(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(longValue, precision, scale);
        }
        int size = (int)longValue;
        int subOffset = (int)(longValue >> 32);
        byte[] decimalBytes = new byte[size];
        System.arraycopy(this.bytes, this.offset + subOffset, decimalBytes, 0, size);
        return Decimal.fromUnscaledBytes(decimalBytes, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        long longValue = this.getLong(pos);
        if (Timestamp.isCompact(precision)) {
            return Timestamp.fromEpochMillis(longValue);
        }
        int nanoOfMillisecond = (int)longValue;
        int subOffset = (int)(longValue >> 32);
        Preconditions.checkArgument(this.bytes.length >= this.offset + subOffset + 8);
        long millisecond = BytesUtils.getLong(this.bytes, this.offset + subOffset);
        return Timestamp.fromEpochMillis(millisecond, nanoOfMillisecond);
    }

    @Override
    public byte[] getBinary(int pos) {
        return BytesUtils.readBinary(this.bytes, this.offset, this.getElementOffset(pos, 8), this.getLong(pos));
    }

    @Override
    public Variant getVariant(int pos) {
        return BytesUtils.readVariant(this.bytes, this.offset, this.getLong(pos));
    }

    @Override
    public InternalArray getArray(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalMap getMap(int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] toBooleanArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short[] toShortArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] toIntArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] toLongArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] toFloatArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] toDoubleArray() {
        throw new UnsupportedOperationException();
    }
}

