/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TrashPolicyDefault
extends TrashPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TrashPolicyDefault.class);
    private static final Path CURRENT = new Path("Current");
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private static final DateFormat CHECKPOINT = new SimpleDateFormat("yyMMddHHmmss");
    private static final DateFormat OLD_CHECKPOINT = new SimpleDateFormat("yyMMddHHmm");
    private static final int MSECS_PER_MINUTE = 60000;
    private long emptierInterval;

    public TrashPolicyDefault() {
    }

    private TrashPolicyDefault(FileSystem fs, Configuration conf) throws IOException {
        this.initialize(conf, fs);
    }

    @Override
    @Deprecated
    public void initialize(Configuration conf, FileSystem fs, Path home) {
        this.fs = fs;
        this.deletionInterval = (long)(conf.getFloat("fs.trash.interval", 0.0f) * 60000.0f);
        this.emptierInterval = (long)(conf.getFloat("fs.trash.checkpoint.interval", 0.0f) * 60000.0f);
    }

    @Override
    public void initialize(Configuration conf, FileSystem fs) {
        this.fs = fs;
        this.deletionInterval = (long)(conf.getFloat("fs.trash.interval", 0.0f) * 60000.0f);
        this.emptierInterval = (long)(conf.getFloat("fs.trash.checkpoint.interval", 0.0f) * 60000.0f);
        if (this.deletionInterval < 0L) {
            LOG.warn("Invalid value {} for deletion interval, deletion interaval can not be negative.Changing to default value 0", (Object)this.deletionInterval);
            this.deletionInterval = 0L;
        }
    }

    private Path makeTrashRelativePath(Path basePath, Path rmFilePath) {
        return Path.mergePaths(basePath, rmFilePath);
    }

    @Override
    public boolean isEnabled() {
        return this.deletionInterval > 0L;
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        if (!this.isEnabled()) {
            return false;
        }
        if (!path.isAbsolute()) {
            path = new Path(this.fs.getWorkingDirectory(), path);
        }
        this.fs.getFileStatus(path);
        String qpath = this.fs.makeQualified(path).toString();
        Path trashRoot = this.fs.getTrashRoot(path);
        Path trashCurrent = new Path(trashRoot, CURRENT);
        if (qpath.startsWith(trashRoot.toString())) {
            return false;
        }
        if (trashRoot.getParent().toString().startsWith(qpath)) {
            throw new IOException("Cannot move \"" + path + "\" to the trash, as it contains the trash");
        }
        Path trashPath = this.makeTrashRelativePath(trashCurrent, path);
        Path baseTrashPath = this.makeTrashRelativePath(trashCurrent, path.getParent());
        IOException cause = null;
        for (int i = 0; i < 2; ++i) {
            try {
                if (!this.fs.mkdirs(baseTrashPath, PERMISSION)) {
                    LOG.warn("Can't create(mkdir) trash directory: " + baseTrashPath);
                    return false;
                }
            }
            catch (FileAlreadyExistsException e) {
                Path existsFilePath = baseTrashPath;
                while (!this.fs.exists(existsFilePath)) {
                    existsFilePath = existsFilePath.getParent();
                }
                baseTrashPath = new Path(baseTrashPath.toString().replace(existsFilePath.toString(), existsFilePath.toString() + Time.now()));
                trashPath = new Path(baseTrashPath, trashPath.getName());
                --i;
                continue;
            }
            catch (IOException e) {
                LOG.warn("Can't create trash directory: " + baseTrashPath, (Throwable)e);
                cause = e;
                break;
            }
            try {
                String orig = trashPath.toString();
                while (this.fs.exists(trashPath)) {
                    trashPath = new Path(orig + Time.now());
                }
                this.fs.rename(path, trashPath, Options.Rename.TO_TRASH);
                LOG.info("Moved: '" + path + "' to trash at: " + trashPath);
                return true;
            }
            catch (IOException e) {
                cause = e;
            }
        }
        throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
    }

    @Override
    public void createCheckpoint() throws IOException {
        this.createCheckpoint(new Date());
    }

    public void createCheckpoint(Date date) throws IOException {
        Collection<FileStatus> trashRoots = this.fs.getTrashRoots(false);
        for (FileStatus trashRoot : trashRoots) {
            LOG.info("TrashPolicyDefault#createCheckpoint for trashRoot: " + trashRoot.getPath());
            this.createCheckpoint(trashRoot.getPath(), date);
        }
    }

    @Override
    public void deleteCheckpoint() throws IOException {
        this.deleteCheckpoint(false);
    }

    @Override
    public void deleteCheckpointsImmediately() throws IOException {
        this.deleteCheckpoint(true);
    }

    private void deleteCheckpoint(boolean deleteImmediately) throws IOException {
        Collection<FileStatus> trashRoots = this.fs.getTrashRoots(false);
        for (FileStatus trashRoot : trashRoots) {
            LOG.info("TrashPolicyDefault#deleteCheckpoint for trashRoot: " + trashRoot.getPath());
            this.deleteCheckpoint(trashRoot.getPath(), deleteImmediately);
        }
    }

    @Override
    public Path getCurrentTrashDir() {
        return new Path(this.fs.getTrashRoot(null), CURRENT);
    }

    @Override
    public Path getCurrentTrashDir(Path path) throws IOException {
        return new Path(this.fs.getTrashRoot(path), CURRENT);
    }

    @Override
    public Runnable getEmptier() throws IOException {
        return new Emptier(this.getConf(), this.emptierInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCheckpoint(Path trashRoot, Date date) throws IOException {
        Path checkpointBase;
        if (!this.fs.exists(new Path(trashRoot, CURRENT))) {
            return;
        }
        DateFormat dateFormat = CHECKPOINT;
        synchronized (dateFormat) {
            checkpointBase = new Path(trashRoot, CHECKPOINT.format(date));
        }
        Path checkpoint = checkpointBase;
        Path current = new Path(trashRoot, CURRENT);
        int attempt = 0;
        while (true) {
            try {
                this.fs.rename(current, checkpoint, Options.Rename.NONE);
                LOG.info("Created trash checkpoint: " + checkpoint.toUri().getPath());
            }
            catch (FileAlreadyExistsException e) {
                if (++attempt > 1000) {
                    throw new IOException("Failed to checkpoint trash: " + checkpoint);
                }
                checkpoint = checkpointBase.suffix("-" + attempt);
                continue;
            }
            break;
        }
    }

    private void deleteCheckpoint(Path trashRoot, boolean deleteImmediately) throws IOException {
        LOG.info("TrashPolicyDefault#deleteCheckpoint for trashRoot: " + trashRoot);
        FileStatus[] dirs = null;
        try {
            dirs = this.fs.listStatus(trashRoot);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        long now = Time.now();
        for (int i = 0; i < dirs.length; ++i) {
            long time;
            Path path = dirs[i].getPath();
            String dir = path.toUri().getPath();
            String name = path.getName();
            if (name.equals(CURRENT.getName())) continue;
            try {
                time = this.getTimeFromCheckpoint(name);
            }
            catch (ParseException e) {
                LOG.warn("Unexpected item in trash: " + dir + ". Ignoring.");
                continue;
            }
            if (now - this.deletionInterval <= time && !deleteImmediately) continue;
            if (this.fs.delete(path, true)) {
                LOG.info("Deleted trash checkpoint: " + dir);
                continue;
            }
            LOG.warn("Couldn't delete checkpoint: " + dir + " Ignoring.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeFromCheckpoint(String name) throws ParseException {
        long time;
        try {
            DateFormat dateFormat = CHECKPOINT;
            synchronized (dateFormat) {
                time = CHECKPOINT.parse(name).getTime();
            }
        }
        catch (ParseException pe) {
            DateFormat dateFormat = OLD_CHECKPOINT;
            synchronized (dateFormat) {
                time = OLD_CHECKPOINT.parse(name).getTime();
            }
        }
        return time;
    }

    protected class Emptier
    implements Runnable {
        private Configuration conf;
        private long emptierInterval;

        Emptier(Configuration conf, long emptierInterval) throws IOException {
            this.conf = conf;
            this.emptierInterval = emptierInterval;
            if (emptierInterval > TrashPolicyDefault.this.deletionInterval || emptierInterval <= 0L) {
                LOG.info("The configured checkpoint interval is " + emptierInterval / 60000L + " minutes. Using an interval of " + TrashPolicyDefault.this.deletionInterval / 60000L + " minutes that is used for deletion instead");
                this.emptierInterval = TrashPolicyDefault.this.deletionInterval;
            }
            LOG.info("Namenode trash configuration: Deletion interval = " + TrashPolicyDefault.this.deletionInterval / 60000L + " minutes, Emptier interval = " + this.emptierInterval / 60000L + " minutes.");
        }

        @Override
        public void run() {
            if (this.emptierInterval == 0L) {
                return;
            }
            block8: while (true) {
                long now = Time.now();
                long end = this.ceiling(now, this.emptierInterval);
                try {
                    Thread.sleep(end - now);
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    now = Time.now();
                    if (now < end) continue;
                    Collection<FileStatus> trashRoots = TrashPolicyDefault.this.fs.getTrashRoots(true);
                    Iterator<FileStatus> iterator2 = trashRoots.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block8;
                        FileStatus trashRoot = iterator2.next();
                        if (!trashRoot.isDirectory()) continue;
                        try {
                            TrashPolicyDefault trash = new TrashPolicyDefault(TrashPolicyDefault.this.fs, this.conf);
                            trash.deleteCheckpoint(trashRoot.getPath(), false);
                            trash.createCheckpoint(trashRoot.getPath(), new Date(now));
                        }
                        catch (IOException e) {
                            LOG.warn("Trash caught: " + e + ". Skipping " + trashRoot.getPath() + ".");
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("RuntimeException during Trash.Emptier.run(): ", (Throwable)e);
                    continue;
                }
                break;
            }
            try {
                TrashPolicyDefault.this.fs.close();
            }
            catch (IOException e) {
                LOG.warn("Trash cannot close FileSystem: ", (Throwable)e);
            }
        }

        private long ceiling(long time, long interval) {
            return this.floor(time, interval) + interval;
        }

        private long floor(long time, long interval) {
            return time / interval * interval;
        }

        @VisibleForTesting
        protected long getEmptierInterval() {
            return this.emptierInterval / 60000L;
        }
    }
}

