/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.azure;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureLocation;

public class AzureStorageConfigurationInfo
extends PolarisStorageConfigurationInfo {
    @Nonnull
    private final String tenantId;
    @JsonProperty(value="multiTenantAppName", required=false)
    @Nullable
    private String multiTenantAppName = null;
    @JsonProperty(value="consentUrl", required=false)
    @Nullable
    private String consentUrl = null;

    @JsonCreator
    public AzureStorageConfigurationInfo(@JsonProperty(value="allowedLocations", required=true) @Nonnull List<String> allowedLocations, @JsonProperty(value="tenantId", required=true) @Nonnull String tenantId) {
        super(PolarisStorageConfigurationInfo.StorageType.AZURE, allowedLocations);
        this.tenantId = tenantId;
    }

    @Override
    public String getFileIoImplClassName() {
        return "org.apache.iceberg.azure.adlsv2.ADLSFileIO";
    }

    @Nonnull
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getMultiTenantAppName() {
        return this.multiTenantAppName;
    }

    public void setMultiTenantAppName(@Nullable String multiTenantAppName) {
        this.multiTenantAppName = multiTenantAppName;
    }

    @Nullable
    public String getConsentUrl() {
        return this.consentUrl;
    }

    public void setConsentUrl(@Nullable String consentUrl) {
        this.consentUrl = consentUrl;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("storageType", (Object)this.getStorageType()).add("tenantId", (Object)this.tenantId).add("allowedLocation", this.getAllowedLocations()).add("multiTenantAppName", (Object)this.multiTenantAppName).add("consentUrl", (Object)this.consentUrl).toString();
    }

    @Override
    public void validatePrefixForStorageType(String loc) {
        AzureLocation location = new AzureLocation(loc);
        Objects.requireNonNull(location);
    }
}

