/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.Resolver;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;

public class PolarisEntityManager {
    private final PolarisMetaStoreManager metaStoreManager;
    private final EntityCache entityCache;
    private final StorageCredentialCache credentialCache;
    private ResolvedPolarisEntity implicitResolvedRootContainerEntity;

    public PolarisEntityManager(@Nonnull PolarisMetaStoreManager metaStoreManager, @Nonnull StorageCredentialCache credentialCache, @Nullable EntityCache entityCache) {
        this.implicitResolvedRootContainerEntity = null;
        this.metaStoreManager = metaStoreManager;
        this.credentialCache = credentialCache;
        this.entityCache = entityCache;
    }

    public Resolver prepareResolver(@Nonnull CallContext callContext, @Nonnull SecurityContext securityContext, @Nullable String referenceCatalogName) {
        return new Resolver(callContext.getPolarisCallContext(), this.metaStoreManager, securityContext, this.entityCache, referenceCatalogName);
    }

    public PolarisResolutionManifest prepareResolutionManifest(@Nonnull CallContext callContext, @Nonnull SecurityContext securityContext, @Nullable String referenceCatalogName) {
        PolarisResolutionManifest manifest = new PolarisResolutionManifest(callContext, this, securityContext, referenceCatalogName);
        manifest.setSimulatedResolvedRootContainerEntity(this.getSimulatedResolvedRootContainerEntity(callContext));
        return manifest;
    }

    private synchronized ResolvedPolarisEntity getSimulatedResolvedRootContainerEntity(CallContext callContext) {
        if (this.implicitResolvedRootContainerEntity == null) {
            PolarisEntity serviceAdminPrincipalRole = PolarisEntity.of((PolarisBaseEntity)this.metaStoreManager.readEntityByName(callContext.getPolarisCallContext(), null, PolarisEntityType.PRINCIPAL_ROLE, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getNameOfPrincipalServiceAdminRole()).getEntity());
            if (serviceAdminPrincipalRole == null) {
                throw new IllegalStateException("Failed to resolve service_admin PrincipalRole");
            }
            PolarisEntity rootContainerEntity = ((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder().setId(0L)).setCatalogId(0L)).setType(PolarisEntityType.ROOT)).setName("root")).build();
            PolarisGrantRecord serviceAdminGrant = new PolarisGrantRecord(0L, 0L, serviceAdminPrincipalRole.getCatalogId(), serviceAdminPrincipalRole.getId(), PolarisPrivilege.SERVICE_MANAGE_ACCESS.getCode());
            this.implicitResolvedRootContainerEntity = new ResolvedPolarisEntity(rootContainerEntity, null, List.of(serviceAdminGrant));
        }
        return this.implicitResolvedRootContainerEntity;
    }

    public StorageCredentialCache getCredentialCache() {
        return this.credentialCache;
    }

    public PolarisEntityManager() {
    }
}

