/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.task;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.quarkus.runtime.Startup;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.service.events.PolarisEventListener;
import org.apache.polaris.service.task.TaskExecutorImpl;
import org.apache.polaris.service.task.TaskFileIOSupplier;

@ApplicationScoped
public class QuarkusTaskExecutorImpl
extends TaskExecutorImpl {
    private final Tracer tracer;

    public QuarkusTaskExecutorImpl() {
        this(null, null, null, null, null);
    }

    @Inject
    public QuarkusTaskExecutorImpl(@Identifier(value="task-executor") ExecutorService executorService, MetaStoreManagerFactory metaStoreManagerFactory, TaskFileIOSupplier fileIOSupplier, Tracer tracer, PolarisEventListener polarisEventListener) {
        super((Executor)executorService, metaStoreManagerFactory, fileIOSupplier, polarisEventListener);
        this.tracer = tracer;
    }

    @Startup
    public void init() {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTask(long taskEntityId, CallContext callContext, int attempt) {
        Span span = this.tracer.spanBuilder("polaris.task").setParent(Context.current()).setAttribute("polaris.realm.id", callContext.getRealmContext().getRealmIdentifier()).setAttribute("polaris.task.entity.id", taskEntityId).setAttribute("polaris.task.attempt", (long)attempt).startSpan();
        try (Scope ignored = span.makeCurrent();){
            super.handleTask(taskEntityId, callContext, attempt);
        }
        finally {
            span.end();
        }
    }
}

