/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.generic;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.service.catalog.CatalogPrefixParser;
import org.apache.polaris.service.catalog.api.PolarisCatalogGenericTableApiService;
import org.apache.polaris.service.catalog.common.CatalogAdapter;
import org.apache.polaris.service.catalog.generic.GenericTableCatalogHandler;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.types.CreateGenericTableRequest;
import org.apache.polaris.service.types.ListGenericTablesResponse;
import org.apache.polaris.service.types.LoadGenericTableResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class GenericTableCatalogAdapter
implements PolarisCatalogGenericTableApiService,
CatalogAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericTableCatalogAdapter.class);
    private final RealmContext realmContext;
    private final CallContext callContext;
    private final PolarisEntityManager entityManager;
    private final PolarisMetaStoreManager metaStoreManager;
    private final PolarisAuthorizer polarisAuthorizer;
    private final ReservedProperties reservedProperties;
    private final CatalogPrefixParser prefixParser;

    @Inject
    public GenericTableCatalogAdapter(RealmContext realmContext, CallContext callContext, PolarisEntityManager entityManager, PolarisMetaStoreManager metaStoreManager, PolarisAuthorizer polarisAuthorizer, CatalogPrefixParser prefixParser, ReservedProperties reservedProperties) {
        this.realmContext = realmContext;
        this.callContext = callContext;
        this.entityManager = entityManager;
        this.metaStoreManager = metaStoreManager;
        this.polarisAuthorizer = polarisAuthorizer;
        this.prefixParser = prefixParser;
        this.reservedProperties = reservedProperties;
        CallContext.setCurrentContext((CallContext)callContext);
    }

    private GenericTableCatalogHandler newHandlerWrapper(SecurityContext securityContext, String prefix) {
        FeatureConfiguration.enforceFeatureEnabledOrThrow((CallContext)this.callContext, (FeatureConfiguration)FeatureConfiguration.ENABLE_GENERIC_TABLES);
        this.validatePrincipal(securityContext);
        return new GenericTableCatalogHandler(this.callContext, this.entityManager, this.metaStoreManager, securityContext, this.prefixParser.prefixToCatalogName(this.realmContext, prefix), this.polarisAuthorizer);
    }

    public Response createGenericTable(String prefix, String namespace, CreateGenericTableRequest createGenericTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        GenericTableCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        LoadGenericTableResponse response = handler.createGenericTable(TableIdentifier.of((Namespace)this.decodeNamespace(namespace), (String)createGenericTableRequest.getName()), createGenericTableRequest.getFormat(), createGenericTableRequest.getDoc(), this.reservedProperties.removeReservedProperties(createGenericTableRequest.getProperties()));
        return Response.ok((Object)response).build();
    }

    public Response dropGenericTable(String prefix, String namespace, String genericTable, RealmContext realmContext, SecurityContext securityContext) {
        GenericTableCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        handler.dropGenericTable(TableIdentifier.of((Namespace)this.decodeNamespace(namespace), (String)genericTable));
        return Response.noContent().build();
    }

    public Response listGenericTables(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        GenericTableCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        ListGenericTablesResponse response = handler.listGenericTables(this.decodeNamespace(namespace));
        return Response.ok((Object)response).build();
    }

    public Response loadGenericTable(String prefix, String namespace, String genericTable, RealmContext realmContext, SecurityContext securityContext) {
        GenericTableCatalogHandler handler = this.newHandlerWrapper(securityContext, prefix);
        LoadGenericTableResponse response = handler.loadGenericTable(TableIdentifier.of((Namespace)this.decodeNamespace(namespace), (String)genericTable));
        return Response.ok((Object)response).build();
    }
}

