/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;

public class UnboundPartitionSpec {
    private final int specId;
    private final List<UnboundPartitionField> fields;

    public UnboundPartitionSpec(int specId, List<UnboundPartitionField> fields) {
        this.specId = specId;
        this.fields = fields;
    }

    public int specId() {
        return this.specId;
    }

    public List<UnboundPartitionField> fields() {
        return this.fields;
    }

    public PartitionSpec bind(Schema schema) {
        return this.copyToBuilder(schema).build();
    }

    public PartitionSpec bind(Schema schema, boolean ignoreMissingFields) {
        return this.copyToBuilder(schema).build(ignoreMissingFields);
    }

    PartitionSpec bindUnchecked(Schema schema) {
        return this.copyToBuilder(schema).buildUnchecked();
    }

    private PartitionSpec.Builder copyToBuilder(Schema schema) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor(schema).withSpecId(this.specId);
        for (UnboundPartitionField field : this.fields) {
            Type fieldType = schema.findType(field.sourceId);
            Transform<?, ?> transform = fieldType != null ? Transforms.fromString(fieldType, field.transform.toString()) : Transforms.fromString(field.transform.toString());
            if (field.partitionId != null) {
                builder.add(field.sourceId, field.partitionId, field.name, transform);
                continue;
            }
            builder.add(field.sourceId, field.name, transform);
        }
        return builder;
    }

    static Builder builder() {
        return new Builder();
    }

    static class UnboundPartitionField {
        private final Transform<?, ?> transform;
        private final int sourceId;
        private final Integer partitionId;
        private final String name;

        public Transform<?, ?> transform() {
            return this.transform;
        }

        public String transformAsString() {
            return this.transform.toString();
        }

        public int sourceId() {
            return this.sourceId;
        }

        public Integer partitionId() {
            return this.partitionId;
        }

        public String name() {
            return this.name;
        }

        private UnboundPartitionField(String transformAsString, int sourceId, Integer partitionId, String name) {
            this.transform = Transforms.fromString(transformAsString);
            this.sourceId = sourceId;
            this.partitionId = partitionId;
            this.name = name;
        }
    }

    static class Builder {
        private final List<UnboundPartitionField> fields = Lists.newArrayList();
        private int specId = 0;

        private Builder() {
        }

        Builder withSpecId(int newSpecId) {
            this.specId = newSpecId;
            return this;
        }

        Builder addField(String transformAsString, int sourceId, int partitionId, String name) {
            this.fields.add(new UnboundPartitionField(transformAsString, sourceId, partitionId, name));
            return this;
        }

        Builder addField(String transformAsString, int sourceId, String name) {
            this.fields.add(new UnboundPartitionField(transformAsString, sourceId, null, name));
            return this;
        }

        UnboundPartitionSpec build() {
            return new UnboundPartitionSpec(this.specId, this.fields);
        }
    }
}

