/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.OidcTlsSupport;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcProviderClientImpl;
import io.quarkus.oidc.runtime.OidcRecorder;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.StepUpAuthenticationPolicy;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.enterprise.event.Event;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

final class TenantContextFactory {
    static volatile boolean userInfoInjectionPointDetected = false;
    private final Set<String> tenantsExpectingServerAvailableEvents;
    private final Vertx vertx;
    private final OidcTlsSupport tlsSupport;
    private final boolean securityEventsEnabled;

    TenantContextFactory(Vertx vertx, TlsConfigurationRegistry tlsConfigurationRegistry, boolean securityEventsEnabled) {
        this.vertx = vertx;
        this.tlsSupport = OidcTlsSupport.of((TlsConfigurationRegistry)tlsConfigurationRegistry);
        this.securityEventsEnabled = securityEventsEnabled;
        this.tenantsExpectingServerAvailableEvents = ConcurrentHashMap.newKeySet();
    }

    TenantConfigContext createDefaultTenantConfig(Map<String, OidcTenantConfig> staticTenants, OidcTenantConfig defaultTenant) {
        String defaultTenantId = defaultTenant.tenantId().get();
        boolean foundNamedStaticTenants = !staticTenants.isEmpty();
        Supplier<Uni<TenantConfigContext>> defaultTenantInitializer = this.createStaticTenantContextCreator(defaultTenant, foundNamedStaticTenants, defaultTenantId);
        return this.createStaticTenantContext(defaultTenant, foundNamedStaticTenants, defaultTenantId, defaultTenantInitializer);
    }

    Map<String, TenantConfigContext> createStaticTenantConfigs(Map<String, OidcTenantConfig> staticTenants, OidcTenantConfig defaultTenant) {
        String defaultTenantId = defaultTenant.tenantId().get();
        HashMap<String, TenantConfigContext> staticTenantsConfig = new HashMap<String, TenantConfigContext>();
        for (Map.Entry<String, OidcTenantConfig> tenant : staticTenants.entrySet()) {
            this.createStaticTenantConfig(defaultTenantId, tenant.getKey(), tenant.getValue(), staticTenantsConfig);
        }
        return Map.copyOf(staticTenantsConfig);
    }

    Uni<TenantConfigContext> createDynamic(OidcTenantConfig oidcConfig) {
        final String tenantId = oidcConfig.tenantId().orElseThrow();
        if ("Default".equals(tenantId)) {
            throw new ConfigurationException("Dynamic tenant ID cannot be same as the default tenant ID: " + tenantId);
        }
        return this.createTenantContext(oidcConfig, false, tenantId).onFailure().transform((Function)new Function<Throwable, Throwable>(){

            @Override
            public Throwable apply(Throwable t) {
                return TenantContextFactory.this.logTenantConfigContextFailure(t, tenantId);
            }
        });
    }

    private void createStaticTenantConfig(String defaultTenantId, String tenantKey, OidcTenantConfig namedTenantConfig, Map<String, TenantConfigContext> staticTenantsConfig) {
        OidcCommonUtils.verifyConfigurationId((String)defaultTenantId, (String)tenantKey, namedTenantConfig.tenantId());
        Supplier<Uni<TenantConfigContext>> staticTenantInitializer = this.createStaticTenantContextCreator(namedTenantConfig, false, tenantKey);
        staticTenantsConfig.put(tenantKey, this.createStaticTenantContext(namedTenantConfig, false, tenantKey, staticTenantInitializer));
    }

    private TenantConfigContext createStaticTenantContext(final OidcTenantConfig oidcConfig, boolean checkNamedTenants, final String tenantId, final Supplier<Uni<TenantConfigContext>> staticTenantCreator) {
        Uni<TenantConfigContext> uniContext = this.createTenantContext(oidcConfig, checkNamedTenants, tenantId);
        try {
            return (TenantConfigContext)uniContext.onFailure().recoverWithItem((Function)new Function<Throwable, TenantConfigContext>(){

                @Override
                public TenantConfigContext apply(Throwable t) {
                    if (t instanceof OIDCException) {
                        OidcRecorder.LOG.warnf("Tenant '%s': '%s'. OIDC server is not available yet, an attempt to connect will be made during the first request. Access to resources protected by this tenant may fail if OIDC server will not become available", (Object)tenantId, (Object)t.getMessage());
                        return TenantConfigContext.createNotReady(null, oidcConfig, staticTenantCreator);
                    }
                    TenantContextFactory.this.logTenantConfigContextFailure(t, tenantId);
                    if (t instanceof ConfigurationException && !oidcConfig.authServerUrl().isPresent() && LaunchMode.DEVELOPMENT == LaunchMode.current()) {
                        return TenantConfigContext.createNotReady(null, oidcConfig, staticTenantCreator);
                    }
                    throw new OIDCException(t);
                }
            }).await().atMost(oidcConfig.connectionTimeout());
        }
        catch (TimeoutException t2) {
            OidcRecorder.LOG.warnf("Tenant '%s': OIDC server is not available after a %d seconds timeout, an attempt to connect will be made during the first request. Access to resources protected by this tenant may fail if OIDC server will not become available", (Object)tenantId, (Object)oidcConfig.connectionTimeout().getSeconds());
            return TenantConfigContext.createNotReady(null, oidcConfig, staticTenantCreator);
        }
    }

    private Supplier<Uni<TenantConfigContext>> createStaticTenantContextCreator(final OidcTenantConfig oidcConfig, final boolean checkNamedTenants, final String tenantId) {
        return new Supplier<Uni<TenantConfigContext>>(){

            @Override
            public Uni<TenantConfigContext> get() {
                return TenantContextFactory.this.createTenantContext(oidcConfig, checkNamedTenants, tenantId).onFailure().transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable t) {
                        return TenantContextFactory.this.logTenantConfigContextFailure(t, tenantId);
                    }
                });
            }
        };
    }

    private Throwable logTenantConfigContextFailure(Throwable t, String tenantId) {
        OidcRecorder.LOG.debugf("'%s' tenant is not initialized: '%s'. Access to resources protected by this tenant will fail.", (Object)tenantId, (Object)t.getMessage());
        return t;
    }

    private Uni<TenantConfigContext> createTenantContext(OidcTenantConfig oidcTenantConfig, boolean checkNamedTenants, String tenantId) {
        final OidcTenantConfig oidcConfig = OidcUtils.resolveProviderConfig(oidcTenantConfig);
        if (!oidcConfig.tenantEnabled()) {
            OidcRecorder.LOG.debugf("'%s' tenant configuration is disabled", (Object)tenantId);
            return Uni.createFrom().item((Object)TenantConfigContext.createReady(new OidcProvider(null, null, null), oidcConfig));
        }
        if (oidcConfig.authServerUrl().isEmpty()) {
            if (oidcConfig.publicKey().isPresent() && oidcConfig.certificateChain().trustStoreFile().isPresent()) {
                throw new ConfigurationException("Both public key and certificate chain verification modes are enabled");
            }
            if (oidcConfig.publicKey().isPresent()) {
                return Uni.createFrom().item((Object)this.createTenantContextFromPublicKey(oidcConfig));
            }
            if (oidcConfig.certificateChain().trustStoreFile().isPresent()) {
                return Uni.createFrom().item((Object)this.createTenantContextToVerifyCertChain(oidcConfig));
            }
        }
        try {
            if (oidcConfig.authServerUrl().isEmpty()) {
                ArcContainer container;
                if ("Default".equals(oidcConfig.tenantId().get()) && (container = Arc.container()) != null && (container.instance(TenantConfigResolver.class, new Annotation[0]).isAvailable() || checkNamedTenants)) {
                    OidcRecorder.LOG.debugf("Default tenant is not configured and will be disabled because either 'TenantConfigResolver' which will resolve tenant configurations is registered or named tenants are configured.", new Object[0]);
                    oidcConfig.tenantEnabled = false;
                    return Uni.createFrom().item((Object)TenantConfigContext.createReady(new OidcProvider(null, null, null), oidcConfig));
                }
                throw new ConfigurationException("'" + this.getConfigPropertyForTenant(tenantId, "auth-server-url") + "' property must be configured");
            }
            OidcCommonUtils.verifyEndpointUrl((String)((String)oidcConfig.authServerUrl().get()));
            OidcCommonUtils.verifyCommonConfiguration((OidcClientCommonConfig)oidcConfig, (boolean)OidcUtils.isServiceApp(oidcConfig), (boolean)true);
        }
        catch (ConfigurationException t) {
            return Uni.createFrom().failure((Throwable)t);
        }
        if (oidcConfig.roles().source().orElse(null) == OidcTenantConfig.Roles.Source.userinfo && !this.enableUserInfo(oidcConfig)) {
            throw new ConfigurationException("UserInfo is not required but UserInfo is expected to be the source of authorization roles");
        }
        if (oidcConfig.token().verifyAccessTokenWithUserInfo().orElse(false).booleanValue() && !OidcUtils.isWebApp(oidcConfig) && !this.enableUserInfo(oidcConfig)) {
            String propertyName = this.getConfigPropertyForTenant(tenantId, "token.verify-access-token-with-user-info");
            throw new ConfigurationException("UserInfo is not required but '%s' is enabled".formatted(propertyName));
        }
        if (!oidcConfig.authentication().idTokenRequired().orElse(true).booleanValue() && OidcUtils.isWebApp(oidcConfig) && StepUpAuthenticationPolicy.isEnabled()) {
            String propertyName = this.getConfigPropertyForTenant(tenantId, "authentication.id-token-required");
            OidcRecorder.LOG.warnf("Step Up Authentication is not supported for tenant '%s', because the internal IdToken is generated by Quarkus. Please see the '%s' configuration property documentation for more information", (Object)tenantId, (Object)propertyName);
        }
        if (!oidcConfig.authentication().idTokenRequired().orElse(true).booleanValue() && !this.enableUserInfo(oidcConfig)) {
            throw new ConfigurationException("UserInfo is not required for OIDC tenant '%s' but it will be needed to verify a code flow access token".formatted(tenantId));
        }
        if (!oidcConfig.discoveryEnabled().orElse(true).booleanValue()) {
            if (!OidcUtils.isServiceApp(oidcConfig) && (oidcConfig.authorizationPath().isEmpty() || oidcConfig.tokenPath().isEmpty())) {
                String authorizationPathProperty = this.getConfigPropertyForTenant(tenantId, "authorization-path");
                String tokenPathProperty = this.getConfigPropertyForTenant(tenantId, "token-path");
                throw new ConfigurationException("'web-app' applications must have '" + authorizationPathProperty + "' and '" + tokenPathProperty + "' properties set when the discovery is disabled.", Set.of(authorizationPathProperty, tokenPathProperty));
            }
            if (oidcConfig.jwksPath().isEmpty() && oidcConfig.introspectionPath().isEmpty()) {
                if (!oidcConfig.authentication().idTokenRequired().orElse(true).booleanValue() && oidcConfig.authentication().userInfoRequired().orElse(false).booleanValue()) {
                    OidcRecorder.LOG.debugf("tenant %s supports only UserInfo", (Object)oidcConfig.tenantId().get());
                } else {
                    throw new ConfigurationException("Either 'jwks-path' or 'introspection-path' properties must be set when the discovery is disabled.", Set.of("quarkus.oidc.jwks-path", "quarkus.oidc.introspection-path"));
                }
            }
            if (oidcConfig.authentication().userInfoRequired().orElse(false).booleanValue() && oidcConfig.userInfoPath().isEmpty()) {
                String configProperty = this.getConfigPropertyForTenant(tenantId, "user-info-path");
                throw new ConfigurationException("UserInfo is required but '" + configProperty + "' is not configured.", Set.of(configProperty));
            }
        }
        if (OidcUtils.isServiceApp(oidcConfig)) {
            if (oidcConfig.token().refreshExpired()) {
                throw new ConfigurationException("The '" + this.getConfigPropertyForTenant(tenantId, "token.refresh-expired") + "' property can only be enabled for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.token().refreshTokenTimeSkew().isPresent()) {
                throw new ConfigurationException("The '" + this.getConfigPropertyForTenant(tenantId, "token.refresh-token-time-skew") + "' property can only be enabled for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.logout().path().isPresent()) {
                throw new ConfigurationException("The '" + this.getConfigPropertyForTenant(tenantId, "logout.path") + "' property can only be enabled for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.roles().source().isPresent() && oidcConfig.roles().source().get() == OidcTenantConfig.Roles.Source.idtoken) {
                throw new ConfigurationException("The '" + this.getConfigPropertyForTenant(tenantId, "roles.source") + "' property can only be set to 'idtoken' for " + String.valueOf((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
        } else if (oidcConfig.token().refreshTokenTimeSkew().isPresent()) {
            oidcConfig.token.setRefreshExpired(true);
        }
        if (oidcConfig.tokenStateManager().strategy() != OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (oidcConfig.authentication().userInfoRequired().orElse(false).booleanValue() || oidcConfig.roles().source().orElse(null) == OidcTenantConfig.Roles.Source.userinfo) {
                throw new ConfigurationException("UserInfo is required but DefaultTokenStateManager is configured to not keep the access token");
            }
            if (oidcConfig.roles().source().orElse(null) == OidcTenantConfig.Roles.Source.accesstoken) {
                throw new ConfigurationException("Access token is required to check the roles but DefaultTokenStateManager is configured to not keep the access token");
            }
        }
        if (oidcConfig.token().verifyAccessTokenWithUserInfo().orElse(false).booleanValue() && !oidcConfig.discoveryEnabled().orElse(true).booleanValue()) {
            if (oidcConfig.userInfoPath().isEmpty()) {
                throw new ConfigurationException("UserInfo path is missing but 'verifyAccessTokenWithUserInfo' is enabled");
            }
            if (oidcConfig.introspectionPath().isPresent()) {
                throw new ConfigurationException("Introspection path is configured and 'verifyAccessTokenWithUserInfo' is enabled, these options are mutually exclusive");
            }
        }
        if (!oidcConfig.token().issuedAtRequired() && oidcConfig.token().age().isPresent()) {
            String tokenIssuedAtRequired = this.getConfigPropertyForTenant(tenantId, "token.issued-at-required");
            String tokenAge = this.getConfigPropertyForTenant(tenantId, "token.age");
            throw new ConfigurationException("The '" + tokenIssuedAtRequired + "' can only be set to false if '" + tokenAge + "' is not set. Either set '" + tokenIssuedAtRequired + "' to true or do not set '" + tokenAge + "'.", Set.of(tokenIssuedAtRequired, tokenAge));
        }
        return this.createOidcProvider(oidcConfig).onItem().transform((Function)new Function<OidcProvider, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(OidcProvider p) {
                return TenantConfigContext.createReady(p, oidcConfig);
            }
        });
    }

    private String getConfigPropertyForTenant(String tenantId, String configSubKey) {
        if ("Default".equals(tenantId)) {
            return "quarkus.oidc." + configSubKey;
        }
        return "quarkus.oidc." + tenantId + "." + configSubKey;
    }

    private boolean enableUserInfo(OidcTenantConfig oidcConfig) {
        Optional<Boolean> userInfoRequired = oidcConfig.authentication().userInfoRequired();
        if (userInfoRequired.isPresent()) {
            if (!userInfoRequired.get().booleanValue()) {
                return false;
            }
        } else {
            oidcConfig.authentication.setUserInfoRequired(true);
        }
        return true;
    }

    private TenantConfigContext createTenantContextFromPublicKey(OidcTenantConfig oidcConfig) {
        if (!OidcUtils.isServiceApp(oidcConfig)) {
            throw new ConfigurationException("'public-key' property can only be used with the 'service' applications");
        }
        OidcRecorder.LOG.debug((Object)"'public-key' property for the local token verification is set, no connection to the OIDC server will be created");
        return TenantConfigContext.createReady(new OidcProvider(oidcConfig.publicKey().get(), oidcConfig), oidcConfig);
    }

    private TenantConfigContext createTenantContextToVerifyCertChain(OidcTenantConfig oidcConfig) {
        if (!OidcUtils.isServiceApp(oidcConfig)) {
            throw new ConfigurationException("Currently only 'service' applications can be used to verify tokens with inlined certificate chains");
        }
        return TenantConfigContext.createReady(new OidcProvider(null, oidcConfig), oidcConfig);
    }

    private OIDCException toOidcException(Throwable cause, String authServerUrl, String tenantId) {
        String message = OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrl);
        OidcRecorder.LOG.warn((Object)message);
        this.fireOidcServerNotAvailableEvent(authServerUrl, tenantId);
        return new OIDCException("OIDC Server is not available", cause);
    }

    private Uni<OidcProvider> createOidcProvider(final OidcTenantConfig oidcConfig) {
        return this.createOidcClientUni(oidcConfig).flatMap((Function)new Function<OidcProviderClientImpl, Uni<? extends OidcProvider>>(){

            @Override
            public Uni<OidcProvider> apply(final OidcProviderClientImpl client) {
                if (oidcConfig.jwks().resolveEarly() && client.getMetadata().getJsonWebKeySetUri() != null && !oidcConfig.token().requireJwtIntrospectionOnly()) {
                    return TenantContextFactory.this.getJsonWebSetUni(client, oidcConfig).onItem().transform((Function)new Function<JsonWebKeySet, OidcProvider>(){

                        @Override
                        public OidcProvider apply(JsonWebKeySet jwks) {
                            return new OidcProvider(client, oidcConfig, jwks);
                        }
                    });
                }
                return Uni.createFrom().item((Object)new OidcProvider(client, oidcConfig, null));
            }
        });
    }

    private Uni<JsonWebKeySet> getJsonWebSetUni(OidcProviderClientImpl client, final OidcTenantConfig oidcConfig) {
        if (!oidcConfig.discoveryEnabled().orElse(true).booleanValue()) {
            final String tenantId = oidcConfig.tenantId().orElse("Default");
            if (this.shouldFireOidcServerAvailableEvent(tenantId)) {
                return this.getJsonWebSetUniWhenDiscoveryDisabled(client, oidcConfig).invoke(new Runnable(){

                    @Override
                    public void run() {
                        TenantContextFactory.this.fireOidcServerAvailableEvent((String)oidcConfig.authServerUrl().get(), tenantId);
                    }
                });
            }
            return this.getJsonWebSetUniWhenDiscoveryDisabled(client, oidcConfig);
        }
        return client.getJsonWebKeySet(null);
    }

    private Uni<JsonWebKeySet> getJsonWebSetUniWhenDiscoveryDisabled(OidcProviderClientImpl client, final OidcTenantConfig oidcConfig) {
        long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
        return client.getJsonWebKeySet(null).onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(OidcCommonUtils.CONNECTION_BACKOFF_DURATION, OidcCommonUtils.CONNECTION_BACKOFF_DURATION).expireIn(connectionDelayInMillisecs).onFailure().transform((Function)new Function<Throwable, Throwable>(){

            @Override
            public Throwable apply(Throwable t) {
                return TenantContextFactory.this.toOidcException(t, (String)oidcConfig.authServerUrl().get(), oidcConfig.tenantId().orElse("Default"));
            }
        }).onFailure().invoke(client::close);
    }

    private Uni<OidcProviderClientImpl> createOidcClientUni(final OidcTenantConfig oidcConfig) {
        final String authServerUriString = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
        WebClientOptions options = new WebClientOptions();
        options.setFollowRedirects(oidcConfig.followRedirects());
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (HttpClientOptions)options, (OidcTlsSupport.TlsConfigSupport)this.tlsSupport.forConfig(oidcConfig.tls()));
        io.vertx.mutiny.core.Vertx mutinyVertx = new io.vertx.mutiny.core.Vertx(this.vertx);
        final WebClient client = WebClient.create((io.vertx.mutiny.core.Vertx)mutinyVertx, (WebClientOptions)options);
        final Map<OidcEndpoint.Type, List<OidcRequestFilter>> oidcRequestFilters = OidcUtils.getOidcRequestFilters(oidcConfig);
        final Map<OidcEndpoint.Type, List<OidcResponseFilter>> oidcResponseFilters = OidcUtils.getOidcResponseFilters(oidcConfig);
        Uni metadataUni = null;
        if (!oidcConfig.discoveryEnabled().orElse(true).booleanValue()) {
            metadataUni = Uni.createFrom().item((Object)this.createLocalMetadata(oidcConfig, authServerUriString));
        } else {
            long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
            OidcRequestContextProperties contextProps = new OidcRequestContextProperties(Map.of("tenant-id", oidcConfig.tenantId().orElse("Default")));
            metadataUni = OidcCommonUtils.discoverMetadata((WebClient)client, oidcRequestFilters, (OidcRequestContextProperties)contextProps, oidcResponseFilters, (String)authServerUriString, (long)connectionDelayInMillisecs, (io.vertx.mutiny.core.Vertx)mutinyVertx, (boolean)oidcConfig.useBlockingDnsLookup()).onItem().transform((Function)new Function<JsonObject, OidcConfigurationMetadata>(){

                @Override
                public OidcConfigurationMetadata apply(JsonObject json) {
                    return new OidcConfigurationMetadata(json, TenantContextFactory.this.createLocalMetadata(oidcConfig, authServerUriString), OidcCommonUtils.getDiscoveryUri((String)authServerUriString));
                }
            });
        }
        return metadataUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<OidcConfigurationMetadata, Throwable, Uni<? extends OidcProviderClientImpl>>(){

            @Override
            public Uni<OidcProviderClientImpl> apply(OidcConfigurationMetadata metadata, Throwable t) {
                String tenantId = oidcConfig.tenantId().orElse("Default");
                if (t != null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)TenantContextFactory.this.toOidcException(t, authServerUriString, tenantId));
                }
                if (TenantContextFactory.this.shouldFireOidcServerAvailableEvent(tenantId)) {
                    TenantContextFactory.this.fireOidcServerAvailableEvent(authServerUriString, tenantId);
                }
                if (metadata == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("OpenId Connect Provider configuration metadata is not configured and can not be discovered"));
                }
                if (oidcConfig.logout().path().isPresent() && oidcConfig.endSessionPath().isEmpty() && metadata.getEndSessionUri() == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("The application supports RP-Initiated Logout but the OpenID Provider does not advertise the end_session_endpoint"));
                }
                if (userInfoInjectionPointDetected && metadata.getUserInfoUri() != null) {
                    TenantContextFactory.this.enableUserInfo(oidcConfig);
                }
                if (oidcConfig.authentication().userInfoRequired().orElse(false).booleanValue() && metadata.getUserInfoUri() == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("UserInfo is required but the OpenID Provider UserInfo endpoint is not configured. Use 'quarkus.oidc.user-info-path' if the discovery is disabled."));
                }
                return Uni.createFrom().item((Object)new OidcProviderClientImpl(client, TenantContextFactory.this.vertx, metadata, oidcConfig, oidcRequestFilters, oidcResponseFilters));
            }
        });
    }

    private OidcConfigurationMetadata createLocalMetadata(OidcTenantConfig oidcConfig, String authServerUriString) {
        String tokenUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.tokenPath());
        String introspectionUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.introspectionPath());
        String authorizationUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.authorizationPath());
        String jwksUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.jwksPath());
        String userInfoUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.userInfoPath());
        String endSessionUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.endSessionPath());
        String registrationUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.registrationPath());
        String revocationUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.revokePath());
        return new OidcConfigurationMetadata(tokenUri, introspectionUri, authorizationUri, jwksUri, userInfoUri, endSessionUri, registrationUri, revocationUri, oidcConfig.token().issuer().orElse(null));
    }

    private void fireOidcServerNotAvailableEvent(String authServerUrl, String tenantId) {
        if (this.fireOidcServerEvent(authServerUrl, SecurityEvent.Type.OIDC_SERVER_NOT_AVAILABLE)) {
            this.tenantsExpectingServerAvailableEvents.add(tenantId);
        }
    }

    private void fireOidcServerAvailableEvent(String authServerUrl, String tenantId) {
        if (this.fireOidcServerEvent(authServerUrl, SecurityEvent.Type.OIDC_SERVER_AVAILABLE)) {
            this.tenantsExpectingServerAvailableEvents.remove(tenantId);
        }
    }

    private boolean shouldFireOidcServerAvailableEvent(String tenantId) {
        return this.tenantsExpectingServerAvailableEvents.contains(tenantId);
    }

    private boolean fireOidcServerEvent(String authServerUrl, SecurityEvent.Type eventType) {
        if (this.securityEventsEnabled) {
            SecurityEventHelper.fire((Event)Arc.container().beanManager().getEvent().select(SecurityEvent.class, new Annotation[0]), (io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(eventType, Map.of("auth-server-url", authServerUrl)));
            return true;
        }
        return false;
    }
}

