/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.google.common.base.Throwables;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.entity.PrincipalRoleEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.service.auth.Authenticator;
import org.apache.polaris.service.auth.PolarisCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Identifier(value="default")
public class DefaultAuthenticator
implements Authenticator {
    public static final String PRINCIPAL_ROLE_ALL = "PRINCIPAL_ROLE:ALL";
    public static final String PRINCIPAL_ROLE_PREFIX = "PRINCIPAL_ROLE:";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticator.class);
    private static final Set<String> ALL_ROLES_REQUESTED = Set.of();
    @Inject
    PolarisMetaStoreManager metaStoreManager;
    @Inject
    CallContext callContext;
    @Inject
    PolarisDiagnostics diagnostics;

    @Override
    public PolarisPrincipal authenticate(PolarisCredential credentials) {
        LOGGER.debug("Resolving principal for credentials: {}", (Object)credentials);
        PrincipalEntity principalEntity = this.resolvePrincipalEntity(credentials);
        Set<String> principalRoles = this.resolvePrincipalRoles(credentials, principalEntity);
        PolarisPrincipal polarisPrincipal = PolarisPrincipal.of((PrincipalEntity)principalEntity, principalRoles);
        LOGGER.debug("Resolved principal: {}", (Object)polarisPrincipal);
        return polarisPrincipal;
    }

    protected PrincipalEntity resolvePrincipalEntity(PolarisCredential credentials) {
        PrincipalEntity principal = null;
        try {
            if (credentials.getPrincipalId() != null && credentials.getPrincipalId() > 0L) {
                principal = this.metaStoreManager.findPrincipalById(this.callContext.getPolarisCallContext(), credentials.getPrincipalId().longValue()).orElse(null);
            } else if (credentials.getPrincipalName() != null) {
                principal = this.metaStoreManager.findPrincipalByName(this.callContext.getPolarisCallContext(), credentials.getPrincipalName()).orElse(null);
            }
        }
        catch (Exception e) {
            LOGGER.atError().addKeyValue("errMsg", (Object)e.getMessage()).addKeyValue("stackTrace", (Object)Throwables.getStackTraceAsString((Throwable)e)).log("Unable to authenticate user with token");
            throw new ServiceFailureException("Unable to fetch principal entity", new Object[0]);
        }
        if (principal == null || principal.getType() != PolarisEntityType.PRINCIPAL) {
            LOGGER.warn("Failed to resolve principal from credentials={}", (Object)credentials);
            throw new NotAuthorizedException("Unable to authenticate", new Object[0]);
        }
        return principal;
    }

    protected Set<String> resolvePrincipalRoles(PolarisCredential credentials, PrincipalEntity principal) {
        Set<String> requestedRoles = this.extractRequestedRoles(credentials);
        LoadGrantsResult loadGrantsResult = this.loadPrincipalGrants(principal);
        Predicate<String> includeRoleFilter = requestedRoles == ALL_ROLES_REQUESTED ? role -> true : requestedRoles::contains;
        Set<String> activeRoles = loadGrantsResult.getGrantRecords().stream().map(gr -> this.metaStoreManager.loadEntity(this.callContext.getPolarisCallContext(), gr.getSecurableCatalogId(), gr.getSecurableId(), PolarisEntityType.PRINCIPAL_ROLE)).filter(BaseResult::isSuccess).map(EntityResult::getEntity).map(PrincipalRoleEntity::of).map(PolarisEntityCore::getName).filter(includeRoleFilter).collect(Collectors.toSet());
        if (requestedRoles != ALL_ROLES_REQUESTED && !activeRoles.containsAll(requestedRoles)) {
            LOGGER.atWarn().addKeyValue("principal", (Object)principal.getName()).addKeyValue("credentials", (Object)credentials).addKeyValue("roles", activeRoles).log("Some principal roles were not found in the principal's grants");
        }
        return activeRoles;
    }

    protected Set<String> extractRequestedRoles(PolarisCredential credentials) {
        Set<String> credentialsRoles = credentials.getPrincipalRoles();
        if (credentialsRoles.contains(PRINCIPAL_ROLE_ALL)) {
            return ALL_ROLES_REQUESTED;
        }
        if (credentialsRoles.stream().anyMatch(s -> !s.startsWith(PRINCIPAL_ROLE_PREFIX))) {
            LOGGER.atWarn().addKeyValue("credentials", (Object)credentials).addKeyValue("roles", credentialsRoles).log("Credentials contain roles that do not start with expected prefix '{}'. These roles will be ignored during authentication.", (Object)PRINCIPAL_ROLE_PREFIX);
        }
        return credentialsRoles.stream().filter(s -> s.startsWith(PRINCIPAL_ROLE_PREFIX)).map(s -> s.substring(PRINCIPAL_ROLE_PREFIX.length())).collect(Collectors.toSet());
    }

    protected LoadGrantsResult loadPrincipalGrants(PrincipalEntity principal) {
        PolarisCallContext polarisContext = this.callContext.getPolarisCallContext();
        LoadGrantsResult principalGrantResults = this.metaStoreManager.loadGrantsToGrantee(polarisContext, (PolarisEntityCore)principal);
        this.diagnostics.check(principalGrantResults.isSuccess(), "Failed to resolve principal roles for principal name={} id={}", principal.getName(), new Object[]{principal.getId()});
        if (!principalGrantResults.isSuccess()) {
            LOGGER.warn("Failed to resolve principal roles for principal name={} id={}", (Object)principal.getName(), (Object)principal.getId());
            throw new NotAuthorizedException("Unable to authenticate", new Object[0]);
        }
        return principalGrantResults;
    }
}

