/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.util.OperationDuration;

public class StatisticDurationTracker
extends OperationDuration
implements DurationTracker {
    private final IOStatisticsStore iostats;
    private final String key;
    private boolean failed;

    public StatisticDurationTracker(IOStatisticsStore iostats, String key) {
        this(iostats, key, 1L);
    }

    public StatisticDurationTracker(IOStatisticsStore iostats, String key, long count) {
        this.iostats = iostats;
        this.key = key;
        if (count > 0L) {
            iostats.incrementCounter(key, count);
        }
    }

    @Override
    public void failed() {
        this.failed = true;
    }

    @Override
    public void close() {
        this.finished();
        String name = this.key;
        if (this.failed) {
            name = this.key + ".failures";
            this.iostats.incrementCounter(name);
        }
        this.iostats.addTimedOperation(name, this.asDuration());
    }

    @Override
    public String toString() {
        return " Duration of " + (this.failed ? this.key + ".failures" : this.key) + ": " + super.toString();
    }
}

