/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

abstract class BaseEntriesTable
extends BaseMetadataTable {
    BaseEntriesTable(Table table, String name) {
        super(table, name);
    }

    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().isEmpty()) {
            schema = TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{102}));
        }
        return TypeUtil.join((Schema)schema, (Schema)MetricsUtil.readableMetricsSchema(this.table().schema(), schema));
    }

    static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        True filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        LoadingCache evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = (PartitionSpec)table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter((Expression)rowFilter, (PartitionSpec)transformedSpec, (boolean)caseSensitive);
        });
        ManifestContentEvaluator manifestContentEvaluator = new ManifestContentEvaluator((Expression)filter, tableSchema.asStruct(), caseSensitive);
        CloseableIterable filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval(manifest) && manifestContentEvaluator.eval((ManifestFile)manifest));
        return CloseableIterable.transform((CloseableIterable)filteredManifests, arg_0 -> BaseEntriesTable.lambda$planFiles$2(table, projectedSchema, (Expression)filter, arg_0));
    }

    private static /* synthetic */ FileScanTask lambda$planFiles$2(Table table, Schema projectedSchema, Expression filter, ManifestFile manifest) {
        return new ManifestReadTask(table, manifest, projectedSchema, filter);
    }

    private static class ManifestContentEvaluator {
        private final Expression boundExpr;

        private ManifestContentEvaluator(Expression expr, Types.StructType structType, boolean caseSensitive) {
            Expression rewritten = Expressions.rewriteNot((Expression)expr);
            this.boundExpr = Binder.bind((Types.StructType)structType, (Expression)rewritten, (boolean)caseSensitive);
        }

        private boolean eval(ManifestFile manifest) {
            return new ManifestEvalVisitor().eval(manifest);
        }

        private class ManifestEvalVisitor
        extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
            private int manifestContentId;
            private static final boolean ROWS_MIGHT_MATCH = true;
            private static final boolean ROWS_CANNOT_MATCH = false;

            private ManifestEvalVisitor() {
            }

            private boolean eval(ManifestFile manifestFile) {
                this.manifestContentId = manifestFile.content().id();
                return ExpressionVisitors.visitEvaluator((Expression)ManifestContentEvaluator.this.boundExpr, (ExpressionVisitors.ExpressionVisitor)this);
            }

            public Boolean alwaysTrue() {
                return true;
            }

            public Boolean alwaysFalse() {
                return false;
            }

            public Boolean not(Boolean result) {
                return result == false;
            }

            public Boolean and(Boolean leftResult, Boolean rightResult) {
                return leftResult != false && rightResult != false;
            }

            public Boolean or(Boolean leftResult, Boolean rightResult) {
                return leftResult != false || rightResult != false;
            }

            public <T> Boolean isNull(BoundReference<T> ref) {
                if (this.fileContent(ref)) {
                    return false;
                }
                return true;
            }

            public <T> Boolean notNull(BoundReference<T> ref) {
                return true;
            }

            public <T> Boolean isNaN(BoundReference<T> ref) {
                if (this.fileContent(ref)) {
                    return false;
                }
                return true;
            }

            public <T> Boolean notNaN(BoundReference<T> ref) {
                return true;
            }

            public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
                Literal intLit;
                if (this.fileContent(ref) && !this.contentMatch((Integer)(intLit = lit.to((Type)Types.IntegerType.get())).value())) {
                    return false;
                }
                return true;
            }

            public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
                Literal intLit;
                if (this.fileContent(ref) && this.contentMatch((Integer)(intLit = lit.to((Type)Types.IntegerType.get())).value())) {
                    return false;
                }
                return true;
            }

            public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
                if (this.fileContent(ref) && literalSet.stream().noneMatch(lit -> this.contentMatch((Integer)lit))) {
                    return false;
                }
                return true;
            }

            public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
                if (this.fileContent(ref) && literalSet.stream().anyMatch(lit -> this.contentMatch((Integer)lit))) {
                    return false;
                }
                return true;
            }

            public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            public <T> Boolean notStartsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            private <T> boolean fileContent(BoundReference<T> ref) {
                return ref.fieldId() == DataFile.CONTENT.fieldId();
            }

            private boolean contentMatch(Integer fileContentId) {
                if (FileContent.DATA.id() == fileContentId.intValue()) {
                    return ManifestContent.DATA.id() == this.manifestContentId;
                }
                if (FileContent.EQUALITY_DELETES.id() == fileContentId.intValue() || FileContent.POSITION_DELETES.id() == fileContentId.intValue()) {
                    return ManifestContent.DELETES.id() == this.manifestContentId;
                }
                return false;
            }
        }
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final Schema projection;
        private final Schema fileProjection;
        private final Schema dataTableSchema;
        private final FileIO io;
        private final ManifestFile manifest;
        private final Map<Integer, PartitionSpec> specsById;

        private ManifestReadTask(Table table, ManifestFile manifest, Schema projection, Expression filter) {
            this(table.schema(), table.io(), table.specs(), manifest, projection, filter);
        }

        ManifestReadTask(Schema dataTableSchema, FileIO io, Map<Integer, PartitionSpec> specsById, ManifestFile manifest, Schema projection, Expression filter) {
            super(DataFiles.fromManifest(manifest), null, SchemaParser.toJson(projection), PartitionSpecParser.toJson(PartitionSpec.unpartitioned()), ResidualEvaluator.unpartitioned((Expression)filter));
            this.projection = projection;
            this.io = io;
            this.manifest = manifest;
            this.specsById = Maps.newHashMap(specsById);
            this.dataTableSchema = dataTableSchema;
            Type fileProjectionType = projection.findType("data_file");
            this.fileProjection = fileProjectionType != null ? new Schema(fileProjectionType.asStructType().fields()) : new Schema(new Types.NestedField[0]);
        }

        @Override
        public long estimatedRowsCount() {
            return (long)this.manifest.addedFilesCount().intValue() + (long)this.manifest.deletedFilesCount().intValue() + (long)this.manifest.existingFilesCount().intValue();
        }

        ManifestFile manifest() {
            return this.manifest;
        }

        public CloseableIterable<StructLike> rows() {
            Types.NestedField readableMetricsField = this.projection.findField("readable_metrics");
            if (readableMetricsField == null) {
                StructProjection structProjection = this.structProjection(this.projection);
                return CloseableIterable.transform(this.entries(this.fileProjection), entry -> structProjection.wrap((StructLike)entry));
            }
            Schema requiredFileProjection = this.requiredFileProjection();
            Schema actualProjection = this.removeReadableMetrics(this.projection, readableMetricsField);
            StructProjection structProjection = this.structProjection(actualProjection);
            return CloseableIterable.transform(this.entries(requiredFileProjection), entry -> this.withReadableMetrics(structProjection, (ManifestEntry<? extends ContentFile<?>>)entry, readableMetricsField));
        }

        private Schema requiredFileProjection() {
            Schema projectionForReadableMetrics = new Schema(MetricsUtil.READABLE_METRIC_COLS.stream().map(MetricsUtil.ReadableMetricColDefinition::originalCol).collect(Collectors.toList()));
            return TypeUtil.join((Schema)this.fileProjection, (Schema)projectionForReadableMetrics);
        }

        private Schema removeReadableMetrics(Schema projectionSchema, Types.NestedField readableMetricsField) {
            Set readableMetricsIds = TypeUtil.getProjectedIds((Type)readableMetricsField.type());
            return TypeUtil.selectNot((Schema)projectionSchema, (Set)readableMetricsIds);
        }

        private StructProjection structProjection(Schema projectedSchema) {
            Schema manifestEntrySchema = ManifestEntry.wrapFileSchema(this.fileProjection.asStruct());
            return StructProjection.create((Schema)manifestEntrySchema, (Schema)projectedSchema);
        }

        private CloseableIterable<? extends ManifestEntry<? extends ContentFile<?>>> entries(Schema fileStructProjection) {
            return ManifestFiles.open(this.manifest, this.io, this.specsById).project(fileStructProjection).entries();
        }

        private StructLike withReadableMetrics(StructProjection structProjection, ManifestEntry<? extends ContentFile<?>> entry, Types.NestedField readableMetricsField) {
            StructProjection struct = structProjection.wrap((StructLike)entry);
            int structSize = this.projection.columns().size();
            MetricsUtil.ReadableMetricsStruct readableMetrics = this.readableMetrics(entry.file(), readableMetricsField);
            int metricsPosition = this.projection.columns().indexOf(readableMetricsField);
            return new MetricsUtil.StructWithReadableMetrics((StructLike)struct, structSize, readableMetrics, metricsPosition);
        }

        private MetricsUtil.ReadableMetricsStruct readableMetrics(ContentFile<?> file, Types.NestedField readableMetricsField) {
            Types.StructType projectedMetricType = readableMetricsField.type().asStructType();
            return MetricsUtil.readableMetricsStruct(this.dataTableSchema, file, projectedMetricType);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of((Object)this);
        }

        FileIO io() {
            return this.io;
        }

        Map<Integer, PartitionSpec> specsById() {
            return this.specsById;
        }

        Schema dataTableSchema() {
            return this.dataTableSchema;
        }

        Schema projection() {
            return this.projection;
        }
    }
}

