/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.inmemory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class InMemoryInputFile
implements InputFile {
    private final String location;
    private final byte[] contents;

    public InMemoryInputFile(byte[] contents) {
        this("memory:" + String.valueOf(UUID.randomUUID()), contents);
    }

    public InMemoryInputFile(String location, byte[] contents) {
        Preconditions.checkNotNull((Object)location, (Object)"location is null");
        Preconditions.checkNotNull((Object)contents, (Object)"contents is null");
        this.location = location;
        this.contents = (byte[])contents.clone();
    }

    public long getLength() {
        return this.contents.length;
    }

    public SeekableInputStream newStream() {
        return new InMemorySeekableInputStream(this.contents);
    }

    public String location() {
        return this.location;
    }

    public boolean exists() {
        return true;
    }

    private static class InMemorySeekableInputStream
    extends SeekableInputStream {
        private final long length;
        private final ByteArrayInputStream delegate;
        private boolean closed = false;

        InMemorySeekableInputStream(byte[] contents) {
            this.length = contents.length;
            this.delegate = new ByteArrayInputStream(contents);
        }

        public long getPos() throws IOException {
            this.checkOpen();
            return this.length - (long)this.delegate.available();
        }

        public void seek(long newPos) throws IOException {
            this.checkOpen();
            this.delegate.reset();
            Preconditions.checkState((this.delegate.skip(newPos) == newPos ? 1 : 0) != 0, (String)"Invalid position %s within stream of length %s", (long)newPos, (long)this.length);
        }

        public int read() {
            this.checkOpen();
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            this.checkOpen();
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) {
            this.checkOpen();
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) {
            this.checkOpen();
            return this.delegate.skip(n);
        }

        public int available() {
            this.checkOpen();
            return this.delegate.available();
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readAheadLimit) {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            this.checkOpen();
            this.delegate.reset();
        }

        public void close() throws IOException {
            this.delegate.close();
            this.closed = true;
        }

        private void checkOpen() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Stream is closed");
        }
    }
}

