/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.registry;

import java.util.Objects;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.metrics.registry.Registry;
import org.apache.seata.metrics.registry.RegistryType;

public class RegistryFactory {
    public static Registry getInstance() {
        String registryTypeName = ConfigurationFactory.getInstance().getConfig("metrics.registryType", "compact");
        if (!StringUtils.isNullOrEmpty((String)registryTypeName)) {
            RegistryType registryType;
            try {
                registryType = RegistryType.getType(registryTypeName);
            }
            catch (Exception exx) {
                throw new NotSupportYetException("not support metrics registry type: " + registryTypeName);
            }
            return (Registry)EnhancedServiceLoader.load(Registry.class, (String)Objects.requireNonNull(registryType).getName());
        }
        return null;
    }
}

