/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.seata.common.DefaultValues;
import org.apache.seata.core.rpc.netty.NettyBaseConfig;

public class NettyServerConfig
extends NettyBaseConfig {
    private int serverListenPort = 0;
    private static final String EPOLL_WORKER_THREAD_PREFIX = "NettyServerEPollWorker";
    private int serverSocketSendBufSize = CONFIG.getInt("transport.serverSocketSendBufSize", 153600);
    private int serverSocketResvBufSize = CONFIG.getInt("transport.serverSocketResvBufSize", 153600);
    private int writeBufferHighWaterMark = CONFIG.getInt("transport.writeBufferHighWaterMark", 0x4000000);
    private int writeBufferLowWaterMark = CONFIG.getInt("transport.writeBufferLowWaterMark", 0x100000);
    private int soBackLogSize = CONFIG.getInt("transport.soBackLogSize", 1024);
    private int serverChannelMaxIdleTimeSeconds = CONFIG.getInt("transport.serverChannelMaxIdleTimeSeconds", 30);
    private static final long RPC_TC_REQUEST_TIMEOUT = CONFIG.getLong("transport.rpcTcRequestTimeout", DefaultValues.DEFAULT_RPC_TC_REQUEST_TIMEOUT);
    private static boolean ENABLE_TC_SERVER_BATCH_SEND_RESPONSE = CONFIG.getBoolean("transport.enableTcServerBatchSendResponse", false);
    private int serverSelectorThreads = Integer.parseInt(System.getProperty("transport.serverSelectorThreads", String.valueOf(WORKER_THREAD_SIZE)));
    private int serverWorkerThreads = Integer.parseInt(System.getProperty("transport.serverWorkerThreads", String.valueOf(WORKER_THREAD_SIZE)));
    private static int minServerPoolSize = CONFIG.getInt("transport.minServerPoolSize", 50);
    private static int maxServerPoolSize = CONFIG.getInt("transport.maxServerPoolSize", 500);
    private static int maxTaskQueueSize = CONFIG.getInt("transport.maxTaskQueueSize", 20000);
    private static int keepAliveTime = CONFIG.getInt("transport.keepAliveTime", 500);
    private static int minHttpPoolSize = CONFIG.getInt("transport.minHttpPoolSize", 10);
    private static int maxHttpPoolSize = CONFIG.getInt("transport.maxHttpPoolSize", 100);
    private static int maxHttpTaskQueueSize = CONFIG.getInt("transport.maxHttpTaskQueueSize", 1000);
    private static int httpKeepAliveTime = CONFIG.getInt("transport.httpPoolKeepAliveTime", 500);
    private static int minBranchResultPoolSize = Integer.parseInt(System.getProperty("transport.minBranchResultPoolSize", String.valueOf(NettyBaseConfig.WorkThreadMode.Pin.getValue())));
    private static int maxBranchResultPoolSize = Integer.parseInt(System.getProperty("transport.maxBranchResultPoolSize", String.valueOf(NettyBaseConfig.WorkThreadMode.Pin.getValue())));
    public static final Class<? extends ServerChannel> SERVER_CHANNEL_CLAZZ = NettyBaseConfig.SERVER_CHANNEL_CLAZZ;

    public int getServerSelectorThreads() {
        return this.serverSelectorThreads;
    }

    public void setServerSelectorThreads(int serverSelectorThreads) {
        this.serverSelectorThreads = serverSelectorThreads;
    }

    public static boolean enableEpoll() {
        return NettyBaseConfig.SERVER_CHANNEL_CLAZZ.equals(EpollServerSocketChannel.class) && Epoll.isAvailable();
    }

    public int getServerSocketSendBufSize() {
        return this.serverSocketSendBufSize;
    }

    public void setServerSocketSendBufSize(int serverSocketSendBufSize) {
        this.serverSocketSendBufSize = serverSocketSendBufSize;
    }

    public int getServerSocketResvBufSize() {
        return this.serverSocketResvBufSize;
    }

    public void setServerSocketResvBufSize(int serverSocketResvBufSize) {
        this.serverSocketResvBufSize = serverSocketResvBufSize;
    }

    public int getServerWorkerThreads() {
        return this.serverWorkerThreads;
    }

    public void setServerWorkerThreads(int serverWorkerThreads) {
        this.serverWorkerThreads = serverWorkerThreads;
    }

    public int getSoBackLogSize() {
        return this.soBackLogSize;
    }

    public void setSoBackLogSize(int soBackLogSize) {
        this.soBackLogSize = soBackLogSize;
    }

    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
    }

    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    public int getServerListenPort() {
        return this.serverListenPort;
    }

    public void setServerListenPort(int port) {
        this.serverListenPort = port;
    }

    public int getChannelMaxReadIdleSeconds() {
        return MAX_READ_IDLE_SECONDS;
    }

    public int getServerChannelMaxIdleTimeSeconds() {
        return this.serverChannelMaxIdleTimeSeconds;
    }

    public static long getRpcRequestTimeout() {
        return RPC_TC_REQUEST_TIMEOUT;
    }

    public String getBossThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.bossThreadPrefix", "NettyBoss");
    }

    public String getWorkerThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.workerThreadPrefix", NettyServerConfig.enableEpoll() ? EPOLL_WORKER_THREAD_PREFIX : "NettyServerNIOWorker");
    }

    public String getExecutorThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.serverExecutorThreadPrefix", "NettyServerBizHandler");
    }

    public int getBossThreadSize() {
        return CONFIG.getInt("transport.threadFactory.bossThreadSize", 1);
    }

    public int getServerShutdownWaitTime() {
        return CONFIG.getInt("transport.shutdown.wait", 13);
    }

    public static int getMinServerPoolSize() {
        return minServerPoolSize;
    }

    public static int getMaxServerPoolSize() {
        return maxServerPoolSize;
    }

    public static int getMaxTaskQueueSize() {
        return maxTaskQueueSize;
    }

    public static int getKeepAliveTime() {
        return keepAliveTime;
    }

    public static int getMinHttpPoolSize() {
        return minHttpPoolSize;
    }

    public static int getMaxHttpPoolSize() {
        return maxHttpPoolSize;
    }

    public static int getMaxHttpTaskQueueSize() {
        return maxHttpTaskQueueSize;
    }

    public static int getHttpKeepAliveTime() {
        return httpKeepAliveTime;
    }

    public static boolean isEnableTcServerBatchSendResponse() {
        return ENABLE_TC_SERVER_BATCH_SEND_RESPONSE;
    }

    public static int getMinBranchResultPoolSize() {
        return minBranchResultPoolSize;
    }

    public static int getMaxBranchResultPoolSize() {
        return maxBranchResultPoolSize;
    }
}

