/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.db.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.core.store.GlobalTransactionDO;
import org.apache.seata.core.store.LogStore;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.storage.SessionConverter;
import org.apache.seata.server.storage.db.store.LogStoreDataBaseDAO;
import org.apache.seata.server.store.AbstractTransactionStoreManager;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.TransactionStoreManager;

public class DataBaseTransactionStoreManager
extends AbstractTransactionStoreManager
implements TransactionStoreManager {
    private static volatile DataBaseTransactionStoreManager instance;
    protected static final Configuration CONFIG;
    protected LogStore logStore;
    protected int logQueryLimit = CONFIG.getInt("store.db.queryLimit", 1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataBaseTransactionStoreManager getInstance() {
        if (instance != null) return instance;
        Class<DataBaseTransactionStoreManager> clazz = DataBaseTransactionStoreManager.class;
        synchronized (DataBaseTransactionStoreManager.class) {
            if (instance != null) return instance;
            instance = new DataBaseTransactionStoreManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DataBaseTransactionStoreManager() {
        String datasourceType = CONFIG.getConfig("store.db.datasource");
        DataSource logStoreDataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)datasourceType)).provide();
        this.logStore = new LogStoreDataBaseDAO(logStoreDataSource);
    }

    public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
        if (TransactionStoreManager.LogOperation.GLOBAL_ADD.equals((Object)logOperation)) {
            return this.logStore.insertGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO((SessionStorable)session));
        }
        if (TransactionStoreManager.LogOperation.GLOBAL_UPDATE.equals((Object)logOperation)) {
            GlobalSession globalSession = (GlobalSession)session;
            if (globalSession.getExpectedStatus() != null) {
                return this.logStore.updateGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO((SessionStorable)session), Integer.valueOf(globalSession.getExpectedStatus().getCode()));
            }
            return this.logStore.updateGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO((SessionStorable)session));
        }
        if (TransactionStoreManager.LogOperation.GLOBAL_REMOVE.equals((Object)logOperation)) {
            return this.logStore.deleteGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO((SessionStorable)session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_ADD.equals((Object)logOperation)) {
            return this.logStore.insertBranchTransactionDO(SessionConverter.convertBranchTransactionDO((SessionStorable)session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_UPDATE.equals((Object)logOperation)) {
            return this.logStore.updateBranchTransactionDO(SessionConverter.convertBranchTransactionDO((SessionStorable)session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_REMOVE.equals((Object)logOperation)) {
            return this.logStore.deleteBranchTransactionDO(SessionConverter.convertBranchTransactionDO((SessionStorable)session));
        }
        throw new StoreException("Unknown LogOperation:" + logOperation.name());
    }

    public GlobalSession readSession(Long transactionId) {
        GlobalTransactionDO globalTransactionDO = this.logStore.queryGlobalTransactionDO(transactionId.longValue());
        if (globalTransactionDO == null) {
            return null;
        }
        List branchTransactionDOs = this.logStore.queryBranchTransactionDO(globalTransactionDO.getXid());
        return this.getGlobalSession(globalTransactionDO, branchTransactionDOs);
    }

    public GlobalSession readSession(String xid) {
        return this.readSession(xid, true);
    }

    public GlobalSession readSession(String xid, boolean withBranchSessions) {
        GlobalTransactionDO globalTransactionDO = this.logStore.queryGlobalTransactionDO(xid);
        if (globalTransactionDO == null) {
            return null;
        }
        List branchTransactionDOs = null;
        if (withBranchSessions) {
            branchTransactionDOs = this.logStore.queryBranchTransactionDO(globalTransactionDO.getXid());
        }
        return this.getGlobalSession(globalTransactionDO, branchTransactionDOs);
    }

    public List<GlobalSession> readSortByTimeoutBeginSessions(boolean withBranchSessions) {
        return this.readSession(new GlobalStatus[]{GlobalStatus.Begin}, withBranchSessions);
    }

    public List<GlobalSession> readSession(GlobalStatus[] statuses, boolean withBranchSessions) {
        int[] states = new int[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            states[i] = statuses[i].getCode();
        }
        List globalTransactionDOs = this.logStore.queryGlobalTransactionDO(states, this.logQueryLimit);
        Map branchTransactionDOsMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)globalTransactionDOs)) {
            List xids = globalTransactionDOs.stream().map(GlobalTransactionDO::getXid).collect(Collectors.toList());
            if (withBranchSessions) {
                List branchTransactionDOs = this.logStore.queryBranchTransactionDO(xids);
                branchTransactionDOsMap = branchTransactionDOs.stream().collect(Collectors.groupingBy(BranchTransactionDO::getXid, LinkedHashMap::new, Collectors.toList()));
            }
        }
        Map finalBranchTransactionDOsMap = branchTransactionDOsMap;
        return globalTransactionDOs.stream().map(globalTransactionDO -> this.getGlobalSession(globalTransactionDO, (List)finalBranchTransactionDOsMap.get(globalTransactionDO.getXid()), withBranchSessions)).collect(Collectors.toList());
    }

    public List<GlobalSession> readSession(SessionCondition sessionCondition) {
        if (StringUtils.isNotBlank((String)sessionCondition.getXid())) {
            GlobalSession globalSession = this.readSession(sessionCondition.getXid());
            if (globalSession != null) {
                ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
                globalSessions.add(globalSession);
                return globalSessions;
            }
        } else if (sessionCondition.getTransactionId() != null) {
            GlobalSession globalSession = this.readSession(sessionCondition.getTransactionId());
            if (globalSession != null) {
                ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
                globalSessions.add(globalSession);
                return globalSessions;
            }
        } else if (CollectionUtils.isNotEmpty((Object[])sessionCondition.getStatuses())) {
            return this.readSession(sessionCondition.getStatuses(), !sessionCondition.isLazyLoadBranch());
        }
        return null;
    }

    private GlobalSession getGlobalSession(GlobalTransactionDO globalTransactionDO, List<BranchTransactionDO> branchTransactionDOs) {
        return this.getGlobalSession(globalTransactionDO, branchTransactionDOs, true);
    }

    private GlobalSession getGlobalSession(GlobalTransactionDO globalTransactionDO, List<BranchTransactionDO> branchTransactionDOs, boolean withBranchSessions) {
        GlobalSession globalSession = SessionConverter.convertGlobalSession((GlobalTransactionDO)globalTransactionDO, (!withBranchSessions ? 1 : 0) != 0);
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            for (BranchTransactionDO branchTransactionDO : branchTransactionDOs) {
                globalSession.add(SessionConverter.convertBranchSession((BranchTransactionDO)branchTransactionDO));
            }
        }
        return globalSession;
    }

    public void setLogStore(LogStore logStore) {
        this.logStore = logStore;
    }

    public void setLogQueryLimit(int logQueryLimit) {
        this.logQueryLimit = logQueryLimit;
    }

    static {
        CONFIG = ConfigurationFactory.getInstance();
    }
}

