/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class DmdbType {
    public static final int CHAR = 0;
    public static final int VARCHAR2 = 1;
    public static final int VARCHAR = 2;
    public static final int BIT = 3;
    public static final int TINYINT = 5;
    public static final int SMALLINT = 6;
    public static final int INT = 7;
    public static final int BIGINT = 8;
    public static final int DECIMAL = 9;
    public static final int REAL = 10;
    public static final int DOUBLE = 11;
    public static final int BLOB = 12;
    public static final int BOOLEAN = 13;
    public static final int DATE = 14;
    public static final int TIME = 15;
    public static final int DATETIME = 16;
    public static final int BINARY = 17;
    public static final int VARBINARY = 18;
    public static final int CLOB = 19;
    public static final int INTERVAL_YM = 20;
    public static final int INTERVAL_DT = 21;
    public static final int TIME_TZ = 22;
    public static final int DATETIME_TZ = 23;
    public static final int DATETIME2 = 26;
    public static final int DATETIME2_TZ = 27;
    public static final int ROWID = 28;
    public static final int NULL = 29;
    public static final int ANY = 31;
    public static final int STAR_ALL = 32;
    public static final int STAR = 33;
    public static final int RECORD = 40;
    public static final int TYPE = 41;
    public static final int TYPE_REF = 42;
    public static final int UNKNOWN = 54;
    public static final int ARRAY = 117;
    public static final int CLASS = 119;
    public static final int CURSOR = 120;
    public static final int PLTYPE_RECORD = 121;
    public static final int SARRAY = 122;
    public static final int CURSOR_ORACLE = -10;
    public static final int BIT_PREC = 1;
    public static final int TINYINT_PREC = 1;
    public static final int SMALLINT_PREC = 2;
    public static final int INT_PREC = 4;
    public static final int BIGINT_PREC = 8;
    public static final int REAL_PREC = 4;
    public static final int DOUBLE_PREC = 8;
    public static final int DATE_PREC = 3;
    public static final int TIME_PREC = 5;
    public static final int DATETIME_PREC = 8;
    public static final int DATETIME2_PREC = 9;
    public static final int TIME_TZ_PREC = 7;
    public static final int DATETIME_TZ_PREC = 10;
    public static final int DATETIME2_TZ_PREC = 11;
    public static final int INTERVAL_YM_PREC = 12;
    public static final int INTERVAL_DT_PREC = 24;
    public static final int VARCHAR_PREC = Short.MAX_VALUE;
    public static final int VARBINARY_PREC = Short.MAX_VALUE;
    public static final int BLOB_PREC = Integer.MAX_VALUE;
    public static final int CLOB_PREC = Integer.MAX_VALUE;
    public static final int CLASS_PREC = 32768;
    public static final int CURSOR_PREC = 32768;
    public static final int NULL_PREC = 0;
    public static final int BFILE_PREC = 512;
    public static final int CURRENCY_PREC = 19;
    public static final int ROWID_PREC = 12;
    public static final int BFILE_SCALE = 6;
    public static final int COMPLEX_SCALE = 5;
    public static final int CURRENCY_SCALE = 4;
    public static final int LOCAL_DATETIME_SCALE_MASK = 4096;
    public static final int ORACLE_FLOAT_SCALE_MASK = 129;
    public static final int ORACLE_DATE_SCALE_MASK = 8192;

    public static boolean isInteger(int n2) {
        return n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8;
    }

    public static boolean isNumeric(int n2) {
        return n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8 || n2 == 10 || n2 == 11 || n2 == 9;
    }

    public static boolean isCharacter(int n2) {
        return n2 == 0 || n2 == 2 || n2 == 1 || n2 == 19;
    }

    public static boolean isBinary(int n2) {
        return n2 == 17 || n2 == 18 || n2 == 12;
    }

    public static boolean isComplexType(int n2, int n3) {
        return n2 == 12 && n3 == 5 || n2 == 117 || n2 == 122 || n2 == 119 || n2 == 121;
    }

    public static int d2jType(Column column, IDmdbConnection iDmdbConnection) {
        int n2 = 1111;
        if (iDmdbConnection != null && iDmdbConnection.compatibleOracle() && DmdbType.isNumeric(column.type)) {
            return 2;
        }
        block0 : switch (column.type) {
            case 13: {
                n2 = 16;
                break;
            }
            case 3: {
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "BOOLEAN") ? 16 : -7;
                break;
            }
            case 5: {
                n2 = -6;
                break;
            }
            case 6: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = -5;
                break;
            }
            case 9: {
                if (StringUtil.equalsIgnoreCase(column.typeName, "NUMERIC") || StringUtil.equalsIgnoreCase(column.typeName, "NUMBER")) {
                    n2 = 2;
                    break;
                }
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 7;
                break;
            }
            case 11: {
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "FLOAT") ? 6 : 8;
                break;
            }
            case 14: {
                n2 = 91;
                break;
            }
            case 15: {
                n2 = 92;
                break;
            }
            case 16: 
            case 26: {
                if (column.mask == 8192) {
                    n2 = 91;
                    break;
                }
                n2 = 93;
                break;
            }
            case 17: {
                n2 = -2;
                break;
            }
            case 18: {
                n2 = -3;
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(column.type, column.scale) && column.typeDescriptor != null) {
                    switch (column.typeDescriptor.column.type) {
                        case 117: 
                        case 122: {
                            n2 = 2003;
                            break block0;
                        }
                        case 119: 
                        case 121: {
                            n2 = 2002;
                            break block0;
                        }
                    }
                    n2 = 2004;
                    break;
                }
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "LONGVARBINARY") ? -4 : 2004;
                break;
            }
            case 0: 
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 19: {
                if (iDmdbConnection != null && iDmdbConnection.getClobAsString()) {
                    n2 = 12;
                    break;
                }
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "LONGVARCHAR") ? -1 : 2005;
                break;
            }
            case 117: 
            case 122: {
                n2 = 2003;
                break;
            }
            case 119: 
            case 121: {
                n2 = 2002;
                break;
            }
            case 54: {
                n2 = 12;
                break;
            }
            case 28: {
                n2 = -8;
                break;
            }
            default: {
                n2 = 1111;
            }
        }
        return n2;
    }

    public static int j2dType(int n2) {
        int n3 = 54;
        switch (n2) {
            case -10: 
            case 120: {
                n3 = 120;
                break;
            }
            case 16: {
                n3 = 3;
                break;
            }
            case -7: {
                n3 = 3;
                break;
            }
            case -6: {
                n3 = 5;
                break;
            }
            case 5: {
                n3 = 6;
                break;
            }
            case 4: {
                n3 = 7;
                break;
            }
            case -5: {
                n3 = 8;
                break;
            }
            case 6: 
            case 7: {
                n3 = 10;
                break;
            }
            case 8: {
                n3 = 11;
                break;
            }
            case 2: 
            case 3: {
                n3 = 9;
                break;
            }
            case -2: {
                n3 = 17;
                break;
            }
            case -3: {
                n3 = 18;
                break;
            }
            case -4: 
            case 2004: {
                n3 = 12;
                break;
            }
            case -15: 
            case 1: {
                n3 = 0;
                break;
            }
            case -9: 
            case 12: {
                n3 = 2;
                break;
            }
            case -1: 
            case 2005: 
            case 2011: {
                n3 = 19;
                break;
            }
            case 91: {
                n3 = 14;
                break;
            }
            case 92: {
                n3 = 15;
                break;
            }
            case 93: {
                n3 = 16;
                break;
            }
            case 2003: {
                n3 = 117;
                break;
            }
            case 2000: 
            case 2002: {
                n3 = 119;
                break;
            }
            case 0: {
                n3 = 29;
                break;
            }
            case 2009: {
                n3 = 19;
                break;
            }
            case 2012: {
                n3 = 120;
                break;
            }
            case -8: {
                n3 = 28;
                break;
            }
            default: {
                n3 = 2;
            }
        }
        return n3;
    }

    public static int d2jPrec(Column column) {
        int n2 = column.prec;
        switch (column.type) {
            case 3: 
            case 13: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 10;
                break;
            }
            case 8: {
                n2 = 19;
                break;
            }
            case 10: {
                n2 = 24;
                break;
            }
            case 11: {
                n2 = 53;
                break;
            }
            case 14: {
                n2 = 10;
                break;
            }
            case 15: {
                n2 = column.scale != 0 ? 9 + column.scale : 8;
                break;
            }
            case 16: 
            case 26: {
                n2 = column.scale != 0 ? 20 + column.scale : 19;
                break;
            }
            case 20: 
            case 21: {
                n2 = column.scale >> 4 & 0xF;
                break;
            }
            case 9: {
                n2 = column.prec == 0 ? 38 : column.prec;
                break;
            }
            default: {
                n2 = column.prec;
            }
        }
        return n2;
    }

    public static String getClassName(int n2, int n3) {
        String string = null;
        block0 : switch (n2) {
            case -7: 
            case 16: {
                string = Boolean.class.getName();
                break;
            }
            case -6: {
                string = Byte.class.getName();
                break;
            }
            case 5: {
                string = Short.class.getName();
                break;
            }
            case 4: {
                string = Integer.class.getName();
                break;
            }
            case -5: {
                string = Long.class.getName();
                break;
            }
            case 2: 
            case 3: {
                string = BigDecimal.class.getName();
                break;
            }
            case 7: {
                string = Float.class.getName();
                break;
            }
            case 6: 
            case 8: {
                string = Double.class.getName();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = String.class.getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = byte[].class.getName();
                break;
            }
            case 91: {
                string = Date.class.getName();
                break;
            }
            case 92: {
                string = Time.class.getName();
                break;
            }
            case 93: {
                string = Timestamp.class.getName();
                break;
            }
            case 2004: {
                string = Blob.class.getName();
                break;
            }
            case 2005: {
                string = Clob.class.getName();
                break;
            }
            case 2003: {
                string = Array.class.getName();
                break;
            }
            case 2002: {
                string = Struct.class.getName();
                break;
            }
            case -8: {
                string = RowId.class.getName();
                break;
            }
            default: {
                switch (n3) {
                    case 22: {
                        string = DmdbTimestamp.class.getName();
                        break block0;
                    }
                    case 21: {
                        string = DmdbIntervalDT.class.getName();
                        break block0;
                    }
                    case 20: {
                        string = DmdbIntervalYM.class.getName();
                        break block0;
                    }
                    case 23: {
                        string = DmdbTimestamp.class.getName();
                        break block0;
                    }
                }
                string = Object.class.getName();
            }
        }
        return string;
    }

    public static boolean canCastToDecimal(Object object) {
        return object != null && (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigDecimal || object instanceof String);
    }

    public static boolean emptyStringToNull(int n2) {
        switch (n2) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public static final int j2dPrec(int n2, int n3) {
        int n4 = n3;
        switch (n2) {
            case 3: 
            case 13: {
                n4 = 1;
                break;
            }
            case 5: {
                n4 = 1;
                break;
            }
            case 6: {
                n4 = 2;
                break;
            }
            case 7: {
                n4 = 4;
                break;
            }
            case 8: {
                n4 = 8;
                break;
            }
            case 1: 
            case 2: {
                n4 = Short.MAX_VALUE;
                break;
            }
            case 19: {
                n4 = Integer.MAX_VALUE;
                break;
            }
            case 18: {
                n4 = Short.MAX_VALUE;
                break;
            }
            case 12: {
                n4 = Integer.MAX_VALUE;
                break;
            }
            case 14: {
                n4 = 3;
                break;
            }
            case 15: {
                n4 = 5;
                break;
            }
            case 16: {
                n4 = 8;
                break;
            }
            case 26: {
                n4 = 9;
                break;
            }
            case 23: {
                n4 = 10;
                break;
            }
            case 27: {
                n4 = 11;
                break;
            }
            case 22: {
                n4 = 7;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 28: 
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                n4 = 0;
                break;
            }
        }
        return n4;
    }

    public static void jclass2dtype(Column column, Object object) {
        if (object == null && !DmdbType.isCharacter(column.type)) {
            column.type = 2;
            column.prec = Short.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if (object instanceof Integer) {
            column.type = 7;
            column.prec = 4;
            column.scale = 0;
            return;
        }
        if (object instanceof Long) {
            column.type = 8;
            column.prec = 8;
            column.scale = 0;
            return;
        }
        if (object instanceof Short) {
            column.type = 6;
            column.prec = 2;
            column.scale = 0;
            return;
        }
        if (object instanceof Float) {
            column.type = 10;
            column.prec = 4;
            column.scale = 0;
            return;
        }
        if (object instanceof Double) {
            column.type = 11;
            column.prec = 8;
            column.scale = 0;
            return;
        }
        if ((object instanceof BigInteger || object instanceof BigDecimal || object instanceof Number) && !DmdbType.isNumeric(column.type)) {
            column.type = 9;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (object instanceof Byte) {
            column.type = 5;
            column.prec = 1;
            column.scale = 0;
            return;
        }
        if (object instanceof byte[] && !DmdbType.isBinary(column.type)) {
            column.type = 18;
            column.prec = Short.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if ((object instanceof InputStream || object instanceof OutputStream || object instanceof Blob) && !DmdbType.isBinary(column.type)) {
            column.type = 12;
            column.prec = Integer.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if (object instanceof Character && !DmdbType.isCharacter(column.type)) {
            column.type = 0;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if ((object instanceof char[] || object instanceof String || object instanceof URL || object instanceof DmdbBFile) && !DmdbType.isCharacter(column.type)) {
            column.type = 2;
            column.prec = Short.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if ((object instanceof Reader || object instanceof Writer || object instanceof Clob || object instanceof SQLXML) && !DmdbType.isCharacter(column.type)) {
            column.type = 19;
            column.prec = Integer.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if (object instanceof Date) {
            column.type = 14;
            column.prec = 3;
            column.scale = 0;
            return;
        }
        if (object instanceof Time) {
            column.type = 14;
            column.prec = 3;
            column.scale = 0;
            return;
        }
        if (object instanceof Timestamp) {
            column.type = 16;
            column.prec = 8;
            return;
        }
        if (object instanceof java.util.Date) {
            column.type = 16;
            column.prec = 8;
            return;
        }
        if (object instanceof LocalDate) {
            column.type = 14;
            column.prec = 3;
            column.scale = 0;
            return;
        }
        if (object instanceof LocalDateTime) {
            column.type = 16;
            column.prec = 8;
            return;
        }
        if (object instanceof LocalTime) {
            column.type = 15;
            column.prec = 5;
            return;
        }
        if (object instanceof OffsetDateTime) {
            column.type = 23;
            column.prec = 10;
            return;
        }
        if (object instanceof OffsetTime) {
            column.type = 22;
            column.prec = 7;
            return;
        }
        if (object instanceof ZonedDateTime) {
            column.type = 23;
            column.prec = 10;
            return;
        }
        if (object instanceof ZoneOffset) {
            column.type = 22;
            column.prec = 7;
            return;
        }
        if (object instanceof DmdbIntervalDT) {
            column.type = 21;
            column.prec = 24;
            column.scale = 0;
            return;
        }
        if (object instanceof DmdbIntervalYM) {
            column.type = 20;
            column.prec = 12;
            column.scale = 0;
            return;
        }
        if (object instanceof Boolean) {
            column.type = 3;
            column.prec = 1;
            column.scale = 0;
            return;
        }
        if (object instanceof Array) {
            column.type = 117;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (object instanceof Struct || object instanceof SQLData || object instanceof SQLInput || object instanceof SQLOutput || object instanceof Ref) {
            column.type = 119;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (object instanceof ResultSet) {
            column.type = 120;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (object instanceof RowId) {
            column.type = 28;
            column.prec = 0;
            column.scale = 0;
            return;
        }
    }

    public static void j2dType(Column column, int n2, int n3, int n4) {
        int n5 = 54;
        int n6 = n3;
        int n7 = n4;
        switch (n2) {
            case -7: 
            case 16: {
                n5 = 3;
                n6 = 1;
                break;
            }
            case -6: {
                n5 = 5;
                n6 = 1;
                break;
            }
            case 5: {
                n5 = 6;
                n6 = 2;
                break;
            }
            case 4: {
                n5 = 7;
                n6 = 4;
                break;
            }
            case -5: {
                n5 = 8;
                n6 = 8;
                break;
            }
            case 6: 
            case 7: {
                n5 = 10;
                n6 = n3 > 0 ? n3 : 0;
                n7 = 0;
                break;
            }
            case 8: {
                n5 = 11;
                n6 = 0;
                n7 = 0;
                break;
            }
            case 2: 
            case 3: {
                n5 = 9;
                n7 = n4 > 0 ? n4 : 0;
                n6 = n3 > 0 && n7 > 0 ? n3 : 0;
                break;
            }
            case -2: {
                n5 = 17;
                n6 = n3 > 0 ? n3 : 0;
                n7 = 0;
                break;
            }
            case -3: {
                n5 = 18;
                n6 = n3 > 0 ? n3 : 0;
                break;
            }
            case -4: 
            case 2004: {
                n5 = 12;
                break;
            }
            case -15: 
            case 1: {
                n5 = 0;
                n6 = n3 > 0 ? n3 : 0;
                break;
            }
            case -9: 
            case 12: {
                n5 = 2;
                n6 = n3 > 0 ? n3 : 0;
                break;
            }
            case -1: 
            case 2005: 
            case 2009: 
            case 2011: {
                n5 = 19;
                break;
            }
            case 91: {
                n5 = 14;
                n6 = 3;
                break;
            }
            case 92: {
                n5 = 15;
                n6 = 5;
                n7 = n4 > 0 ? n4 : 0;
                break;
            }
            case 93: {
                n5 = 16;
                n6 = 8;
                n7 = n4 > 0 ? n4 : 0;
                break;
            }
            case 2003: {
                n5 = 117;
                break;
            }
            case 2000: 
            case 2002: {
                n5 = 119;
                n6 = 32768;
                break;
            }
            case -8: {
                n5 = 28;
                n6 = 0;
                n7 = 0;
                break;
            }
            default: {
                n5 = 2;
                n6 = Short.MAX_VALUE;
            }
        }
        column.type = n5;
        column.prec = n6;
        column.scale = n7;
    }

    public static String getDTypeName(Column column) {
        String string = "varchar";
        block0 : switch (column.type) {
            case 3: 
            case 13: {
                string = "bit";
                break;
            }
            case 5: {
                string = "tinyint";
                break;
            }
            case 6: {
                string = "smallint";
                break;
            }
            case 7: {
                string = "integer";
                break;
            }
            case 8: {
                string = "bigint";
                break;
            }
            case 10: {
                string = "real";
                break;
            }
            case 11: {
                string = "double";
                break;
            }
            case 9: {
                string = "decimal";
                break;
            }
            case 0: {
                string = "char";
                break;
            }
            case 1: 
            case 2: {
                if (column.mask == 3) {
                    string = "bfile";
                    break;
                }
                string = "varchar";
                break;
            }
            case 19: {
                string = "clob";
                break;
            }
            case 17: {
                string = "binary";
                break;
            }
            case 18: {
                string = "varbinary";
                break;
            }
            case 12: {
                string = "blob";
                break;
            }
            case 14: {
                string = "date";
                break;
            }
            case 15: {
                string = "time";
                break;
            }
            case 16: 
            case 26: {
                if (column.mask == 8192) {
                    string = "date";
                    break;
                }
                if (column.mask == 4) {
                    string = "timestamp with local time zone";
                    break;
                }
                string = "timestamp";
                break;
            }
            case 22: {
                string = "time with time zone";
                break;
            }
            case 23: 
            case 27: {
                string = "timestamp with time zone";
                break;
            }
            case 21: {
                int n2 = (column.scale & 0xFF00) >> 8;
                switch (n2) {
                    case 3: {
                        string = "interval day";
                        break block0;
                    }
                    case 4: {
                        string = "interval day to hour";
                        break block0;
                    }
                    case 5: {
                        string = "interval day to minute";
                        break block0;
                    }
                    case 6: {
                        string = "interval day to second";
                        break block0;
                    }
                    case 7: {
                        string = "interval hour";
                        break block0;
                    }
                    case 8: {
                        string = "interval hour to minute";
                        break block0;
                    }
                    case 9: {
                        string = "interval hour to second";
                        break block0;
                    }
                    case 10: {
                        string = "interval minute";
                        break block0;
                    }
                    case 11: {
                        string = "interval minute to second";
                        break block0;
                    }
                    case 12: {
                        string = "interval second";
                        break block0;
                    }
                }
                break;
            }
            case 20: {
                int n3 = (column.scale & 0xFF00) >> 8;
                switch (n3) {
                    case 0: {
                        string = "interval year";
                        break block0;
                    }
                    case 1: {
                        string = "interval year to month";
                        break block0;
                    }
                    case 2: {
                        string = "interval month";
                        break block0;
                    }
                }
                break;
            }
            case 117: {
                string = "array";
                break;
            }
            case 119: {
                string = "class";
                break;
            }
            case 120: {
                string = "cursor";
                break;
            }
            case 40: {
                string = "record";
                break;
            }
            case 122: {
                string = "sarray";
                break;
            }
            case 41: 
            case 42: {
                string = "type";
                break;
            }
            case 121: {
                string = "record";
                break;
            }
            case 28: {
                string = "rowid";
                break;
            }
            default: {
                string = "varchar";
            }
        }
        return string.toUpperCase();
    }
}

