/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.builder;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fury.Fury;
import org.apache.fury.builder.Generated;
import org.apache.fury.builder.ObjectCodecBuilder;
import org.apache.fury.builder.ObjectCodecOptimizer;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.Expression;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.meta.ClassDef;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.serializer.CodegenSerializer;
import org.apache.fury.serializer.MetaSharedSerializer;
import org.apache.fury.serializer.ObjectSerializer;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.Serializers;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.DescriptorGrouper;
import org.apache.fury.util.ExceptionUtils;
import org.apache.fury.util.GraalvmSupport;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.record.RecordComponent;
import org.apache.fury.util.record.RecordUtils;

public class MetaSharedCodecBuilder
extends ObjectCodecBuilder {
    private final ClassDef classDef;
    private static final Map<Long, Integer> idGenerator = new ConcurrentHashMap<Long, Integer>();

    public MetaSharedCodecBuilder(TypeRef<?> beanType, Fury fury, ClassDef classDef) {
        super(beanType, fury, Generated.GeneratedMetaSharedSerializer.class);
        Preconditions.checkArgument(!fury.getConfig().checkClassVersion(), "Class version check should be disabled when compatible mode is enabled.");
        this.classDef = classDef;
        Collection descriptors = this.visitFury(f -> MetaSharedSerializer.consolidateFields(f.getClassResolver(), this.beanClass, classDef));
        DescriptorGrouper grouper = DescriptorGrouper.createDescriptorGrouper(fury.getClassResolver()::isMonomorphic, descriptors, false, fury.compressInt(), fury.compressLong());
        this.objectCodecOptimizer = new ObjectCodecOptimizer(this.beanClass, grouper, !fury.isBasicTypesRefIgnored(), this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String codecSuffix() {
        Integer id = idGenerator.get(this.classDef.getId());
        if (id == null) {
            Map<Long, Integer> map = idGenerator;
            synchronized (map) {
                id = idGenerator.computeIfAbsent(this.classDef.getId(), k -> idGenerator.size());
            }
        }
        return "MetaShared" + id;
    }

    @Override
    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage(this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.extendsClasses(this.ctx.type(this.parentSerializerClass));
        this.ctx.reserveName("classType");
        this.ctx.reserveName("serializer");
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        String constructorCode = StringUtils.format("super(${fury}, ${cls});\nthis.${fury} = ${fury};\n${serializer} = ${builderClass}.setCodegenSerializer(${fury}, ${cls}, this);\n", "fury", "fury", "cls", "classType", "builderClass", MetaSharedCodecBuilder.class.getName(), "serializer", "serializer");
        this.ctx.clearExprState();
        Expression decodeExpr = this.buildDecodeExpression();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        decodeCode = this.ctx.optimizeMethodCode(decodeCode);
        this.ctx.overrideMethod("read", decodeCode, Object.class, MemoryBuffer.class, "buffer");
        this.registerJITNotifyCallback();
        this.ctx.addConstructor(constructorCode, Fury.class, "fury", Class.class, "classType");
        return this.ctx.genCode();
    }

    @Override
    protected void addCommonImports() {
        super.addCommonImports();
        this.ctx.addImport(Generated.GeneratedMetaSharedSerializer.class);
    }

    public static Serializer setCodegenSerializer(Fury fury, Class<?> cls, Generated.GeneratedMetaSharedSerializer s) {
        if (GraalvmSupport.isGraalRuntime()) {
            return fury.getJITContext().asyncVisitFury(f -> f.getClassResolver().getSerializer(s.getType()));
        }
        Class serializerClass = fury.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(fury, s.getType()), c -> {
            s.serializer = Serializers.newSerializer(fury, s.getType(), c);
        });
        return Serializers.newSerializer(fury, cls, serializerClass);
    }

    @Override
    public Expression buildEncodeExpression() {
        throw new IllegalStateException("unreachable");
    }

    @Override
    protected Expression buildComponentsArray() {
        return this.buildDefaultComponentsArray();
    }

    @Override
    protected Expression createRecord(SortedMap<Integer, Expression> recordComponents) {
        RecordComponent[] components = RecordUtils.getRecordComponents(this.beanClass);
        Object[] defaultValues = RecordUtils.buildRecordComponentDefaultValues(this.beanClass);
        for (int i = 0; i < defaultValues.length; ++i) {
            if (recordComponents.containsKey(i)) continue;
            Object defaultValue = defaultValues[i];
            assert (components != null);
            RecordComponent component = components[i];
            recordComponents.put(i, new Expression.Literal(defaultValue, TypeRef.of(component.getType())));
        }
        Expression[] params = recordComponents.values().toArray(new Expression[0]);
        return new Expression.NewInstance(this.beanType, params);
    }

    @Override
    protected Expression setFieldValue(Expression bean, Descriptor descriptor, Expression value) {
        if (descriptor.getField() == null) {
            return new Expression.StaticInvoke(ExceptionUtils.class, "ignore", value);
        }
        return super.setFieldValue(bean, descriptor, value);
    }
}

