/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.lang.reflect.Method;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;

public class Compatibility {
    private static final Method closeAllWithReasonMethod;
    private static final Method closeAllMethod;
    private static final Method closeWithReasonMethod;
    private static final Method closeMethod;
    private static final Object disconnectReasonObj;

    public static void serverCnxnFactoryCloseAll(ServerCnxnFactory factory) {
        try {
            if (closeAllMethod != null) {
                closeAllMethod.invoke((Object)factory, new Object[0]);
            } else {
                closeAllWithReasonMethod.invoke((Object)factory, disconnectReasonObj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not close factory", e);
        }
    }

    public static void serverCnxnClose(ServerCnxn cnxn) {
        try {
            if (closeMethod != null) {
                closeMethod.invoke((Object)cnxn, new Object[0]);
            } else {
                closeWithReasonMethod.invoke((Object)cnxn, disconnectReasonObj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not close connection", e);
        }
    }

    static {
        Method localCloseMethod;
        Method localCloseAllMethod;
        Method localCloseWithReasonMethod;
        Method localCloseAllWithReasonMethod;
        Object localDisconnectReasonObj;
        try {
            Class<?> disconnectReasonClass = Class.forName("org.apache.zookeeper.server.ServerCnxn$DisconnectReason");
            localDisconnectReasonObj = Enum.valueOf(disconnectReasonClass, "UNKNOWN");
            localCloseAllWithReasonMethod = ServerCnxnFactory.class.getDeclaredMethod("closeAll", disconnectReasonClass);
            localCloseWithReasonMethod = ServerCnxn.class.getDeclaredMethod("close", disconnectReasonClass);
            localCloseAllMethod = null;
            localCloseMethod = null;
            localCloseAllWithReasonMethod.setAccessible(true);
            localCloseWithReasonMethod.setAccessible(true);
        }
        catch (Throwable e) {
            localDisconnectReasonObj = null;
            localCloseAllWithReasonMethod = null;
            localCloseWithReasonMethod = null;
            try {
                localCloseAllMethod = ServerCnxnFactory.class.getDeclaredMethod("closeAll", new Class[0]);
                localCloseMethod = ServerCnxn.class.getDeclaredMethod("close", new Class[0]);
                localCloseAllMethod.setAccessible(true);
                localCloseMethod.setAccessible(true);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Could not reflectively find ServerCnxnFactory/ServerCnxn close methods");
            }
        }
        disconnectReasonObj = localDisconnectReasonObj;
        closeAllWithReasonMethod = localCloseAllWithReasonMethod;
        closeAllMethod = localCloseAllMethod;
        closeMethod = localCloseMethod;
        closeWithReasonMethod = localCloseWithReasonMethod;
    }
}

