/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rpc.RpcContext;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcRequestClosure
implements Closure {
    private static final Logger LOG = LoggerFactory.getLogger(RpcRequestClosure.class);
    private static final AtomicIntegerFieldUpdater<RpcRequestClosure> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RpcRequestClosure.class, "state");
    private static final int PENDING = 0;
    private static final int RESPOND = 1;
    private final RpcContext rpcCtx;
    private final Message defaultResp;
    private volatile int state = 0;

    public RpcRequestClosure(RpcContext rpcCtx) {
        this(rpcCtx, null);
    }

    public RpcRequestClosure(RpcContext rpcCtx, Message defaultResp) {
        this.rpcCtx = rpcCtx;
        this.defaultResp = defaultResp;
    }

    public RpcContext getRpcCtx() {
        return this.rpcCtx;
    }

    public void sendResponse(Message msg) {
        if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
            LOG.warn("A response: {} sent repeatedly!", (Object)msg);
            return;
        }
        this.rpcCtx.sendResponse(msg);
    }

    @Override
    public void run(Status status) {
        this.sendResponse(RpcFactoryHelper.responseFactory().newResponse(this.defaultResp, status));
    }
}

