/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.tools;

import java.util.HashMap;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.mcp.core.props.NameSpaceDetail;
import org.apache.seata.mcp.service.ConsoleApiService;
import org.apache.seata.mcp.service.ModifyConfirmService;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.annotation.McpToolParam;
import org.springframework.stereotype.Service;

@Service
public class BranchSessionTools {
    private final ConsoleApiService mcpRPCService;
    private final ModifyConfirmService modifyConfirmService;

    public BranchSessionTools(ConsoleApiService mcpRPCService, ModifyConfirmService modifyConfirmService) {
        this.mcpRPCService = mcpRPCService;
        this.modifyConfirmService = modifyConfirmService;
    }

    @McpTool(description="Delete branch transactions, Get the modify key before you delete")
    public String deleteBranchSession(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Branch transaction id") String branchId, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        pathParams.put("branchId", branchId);
        String result = this.mcpRPCService.deleteCallTC(nameSpaceDetail, "/api/v1/console/branchSession/deleteBranchSession", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("delete branch session failed, xid: %s, branchId: %s", xid, branchId);
        }
        return result;
    }

    @McpTool(description="Stop the branch transaction retry, Get the modify key before you stop")
    public String stopBranchSession(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Branch transaction id") String branchId, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        pathParams.put("branchId", branchId);
        String result = this.mcpRPCService.putCallTC(nameSpaceDetail, "/api/v1/console/branchSession/stopBranchSession", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("stop branch session failed, xid: %s, branchId: %s", xid, branchId);
        }
        return result;
    }

    @McpTool(description="Initiate a branch transaction retries, Get the modify key before you start")
    public String startBranchRetry(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Branch transaction id") String branchId, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        pathParams.put("branchId", branchId);
        String result = this.mcpRPCService.putCallTC(nameSpaceDetail, "/api/v1/console/branchSession/startBranchSession", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("start branch session failed, xid: %s, branchId: %s", xid, branchId);
        }
        return result;
    }
}

