/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import net.logstash.logback.marker.SingleFieldAppendingMarker;

public class RawJsonAppendingMarker
extends SingleFieldAppendingMarker {
    public static final String MARKER_NAME = "LS_APPEND_RAW";
    private final String rawJson;

    public RawJsonAppendingMarker(String fieldName, String rawJson) {
        super(MARKER_NAME, fieldName);
        this.rawJson = Objects.requireNonNull(rawJson, "rawJson must not be null");
    }

    public RawJsonAppendingMarker(String fieldName, String rawJson, String messageFormatPattern) {
        super(MARKER_NAME, fieldName, messageFormatPattern);
        this.rawJson = Objects.requireNonNull(rawJson, "rawJson must not be null");
    }

    @Override
    protected void writeFieldValue(JsonGenerator generator) throws IOException {
        generator.writeRawValue(this.rawJson);
    }

    @Override
    public Object getFieldValue() {
        return this.rawJson;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RawJsonAppendingMarker)) {
            return false;
        }
        RawJsonAppendingMarker other = (RawJsonAppendingMarker)obj;
        return Objects.equals(this.rawJson, other.rawJson);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.rawJson.hashCode();
        return result;
    }
}

