/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.profile.enumeration;

import com.alipay.sofa.common.profile.enumeration.Enum;

public abstract class IntegerEnum
extends Enum {
    private static final long serialVersionUID = 343392921439669443L;

    protected static final Enum create(int value) {
        return IntegerEnum.createEnum(new Integer(value));
    }

    protected static final Enum create(Number value) {
        return IntegerEnum.createEnum(new Integer(value.intValue()));
    }

    protected static final Enum create(String name, int value) {
        return IntegerEnum.createEnum(name, new Integer(value));
    }

    protected static final Enum create(String name, Number value) {
        return IntegerEnum.createEnum(name, new Integer(value.intValue()));
    }

    protected static Object createEnumType() {
        return new Enum.EnumType(){

            @Override
            protected Class getUnderlyingClass() {
                return Integer.class;
            }

            @Override
            protected Number getNextValue(Number value, boolean flagMode) {
                if (value == null) {
                    return flagMode ? new Integer(1) : new Integer(0);
                }
                int intValue = (Integer)value;
                return flagMode ? new Integer(intValue << 1) : new Integer(intValue + 1);
            }

            @Override
            protected boolean isZero(Number value) {
                return (Integer)value == 0;
            }
        };
    }

    @Override
    public int intValue() {
        return (Integer)this.getValue();
    }

    @Override
    public long longValue() {
        return ((Integer)this.getValue()).longValue();
    }

    @Override
    public double doubleValue() {
        return ((Integer)this.getValue()).doubleValue();
    }

    @Override
    public float floatValue() {
        return ((Integer)this.getValue()).floatValue();
    }

    @Override
    public String toHexString() {
        return Integer.toHexString((Integer)this.getValue());
    }

    @Override
    public String toOctalString() {
        return Integer.toOctalString((Integer)this.getValue());
    }

    @Override
    public String toBinaryString() {
        return Integer.toBinaryString((Integer)this.getValue());
    }
}

