/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupForBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;

public class SitesConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<SitesConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes;
    private final List<BackupConfigurationBuilder> backups = new ArrayList<BackupConfigurationBuilder>(2);
    private final BackupForBuilder backupForBuilder;

    public SitesConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.attributes = SitesConfiguration.attributeDefinitionSet();
        this.backupForBuilder = new BackupForBuilder(builder);
    }

    public BackupConfigurationBuilder addBackup() {
        BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
        this.backups.add(bcb);
        return bcb;
    }

    public ConfigurationBuilderInfo getNewBuilderInfo(String name) {
        if (name.equals(Element.BACKUP.getLocalName())) {
            return this.addBackup();
        }
        return null;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return new ArrayList<ConfigurationBuilderInfo>(this.backups);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition<?> getElementDefinition() {
        return SitesConfiguration.ELEMENT_DEFINITION;
    }

    public List<BackupConfigurationBuilder> backups() {
        return this.backups;
    }

    public SitesConfigurationBuilder disableBackups(boolean disable) {
        this.attributes.attribute(SitesConfiguration.DISABLE_BACKUPS).set((Object)disable);
        return this;
    }

    public SitesConfigurationBuilder addInUseBackupSite(String site) {
        Set sites = (Set)this.attributes.attribute(SitesConfiguration.IN_USE_BACKUP_SITES).get();
        sites.add(site);
        this.attributes.attribute(SitesConfiguration.IN_USE_BACKUP_SITES).set((Object)sites);
        return this;
    }

    public BackupForBuilder backupFor() {
        return this.backupForBuilder;
    }

    public SitesConfigurationBuilder mergePolicy(XSiteEntryMergePolicy<?, ?> mergePolicy) {
        this.attributes.attribute(SitesConfiguration.MERGE_POLICY).set(mergePolicy);
        return this;
    }

    public void validate() {
        this.backupForBuilder.validate();
        HashSet<String> backupNames = new HashSet<String>(this.backups.size());
        for (BackupConfigurationBuilder bcb : this.backups) {
            if (!backupNames.add(bcb.site())) {
                throw Log.CONFIG.multipleSitesWithSameName(bcb.site());
            }
            bcb.validate();
        }
        if (!backupNames.isEmpty() && !this.builder.clustering().cacheMode().isClustered()) {
            throw Log.CONFIG.xsiteInLocalCache();
        }
        if (this.attributes.attribute(SitesConfiguration.MERGE_POLICY).get() == null) {
            throw Log.CONFIG.missingXSiteEntryMergePolicy();
        }
        for (String site : (Set)this.attributes.attribute(SitesConfiguration.IN_USE_BACKUP_SITES).get()) {
            boolean found = false;
            for (BackupConfigurationBuilder bcb : this.backups) {
                if (!bcb.site().equals(site)) continue;
                found = true;
            }
            if (found) continue;
            throw Log.CONFIG.siteMustBeInBackups(site);
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.backupForBuilder.validate(globalConfig);
        for (BackupConfigurationBuilder bcb : this.backups) {
            bcb.validate(globalConfig);
        }
    }

    public SitesConfiguration create() {
        ArrayList<BackupConfiguration> backupConfigurations = new ArrayList<BackupConfiguration>(this.backups.size());
        for (BackupConfigurationBuilder bcb : this.backups) {
            backupConfigurations.add(bcb.create());
        }
        return new SitesConfiguration(this.attributes.protect(), backupConfigurations, this.backupForBuilder.create());
    }

    public SitesConfigurationBuilder read(SitesConfiguration template) {
        this.attributes.read(template.attributes());
        this.backupForBuilder.read(template.backupFor());
        for (BackupConfiguration bc : template.allBackups()) {
            BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
            bcb.read(bc);
            this.backups.add(bcb);
        }
        return this;
    }
}

