/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;

@Internal
final class ResolvedSchemaJsonDeserializer
extends StdDeserializer<ResolvedSchema> {
    private static final long serialVersionUID = 1L;

    ResolvedSchemaJsonDeserializer() {
        super(ResolvedSchema.class);
    }

    public ResolvedSchema deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        ObjectNode jsonNode = (ObjectNode)jsonParser.readValueAsTree();
        List columns = (List)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("columns"), jsonParser.getCodec()), (JavaType)ctx.getTypeFactory().constructCollectionType(List.class, Column.class));
        List watermarkSpecs = (List)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("watermarkSpecs"), jsonParser.getCodec()), (JavaType)ctx.getTypeFactory().constructCollectionType(List.class, WatermarkSpec.class));
        UniqueConstraint primaryKey = JsonSerdeUtil.deserializeOptionalField(jsonNode, "primaryKey", UniqueConstraint.class, jsonParser.getCodec(), ctx).orElse(null);
        return new ResolvedSchema(columns, watermarkSpecs, primaryKey);
    }
}

