/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.search.grouping.CollapsingDocValuesSource;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;

public final class CollapsingTopDocsCollector<T>
extends FirstPassGroupingCollector<T> {
    protected final String collapseField;
    protected final Sort sort;
    protected Scorer scorer;
    private int totalHitCount;
    private float maxScore;
    private final boolean trackMaxScore;

    CollapsingTopDocsCollector(GroupSelector<T> groupSelector, String collapseField, Sort sort, int topN, boolean trackMaxScore) {
        super(groupSelector, sort, topN);
        this.collapseField = collapseField;
        this.trackMaxScore = trackMaxScore;
        this.maxScore = trackMaxScore ? Float.NEGATIVE_INFINITY : Float.NaN;
        this.sort = sort;
    }

    public CollapseTopFieldDocs getTopDocs() throws IOException {
        Collection groups = super.getTopGroups(0, true);
        if (groups == null) {
            return new CollapseTopFieldDocs(this.collapseField, this.totalHitCount, new ScoreDoc[0], this.sort.getSort(), new Object[0], Float.NaN);
        }
        FieldDoc[] docs = new FieldDoc[groups.size()];
        Object[] collapseValues = new Object[groups.size()];
        int scorePos = -1;
        for (int index = 0; index < this.sort.getSort().length; ++index) {
            SortField sortField = this.sort.getSort()[index];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            scorePos = index;
            break;
        }
        int pos = 0;
        Iterator it = this.orderedGroups.iterator();
        for (SearchGroup group : groups) {
            assert (it.hasNext());
            CollectedSearchGroup col = (CollectedSearchGroup)it.next();
            float score = Float.NaN;
            if (scorePos != -1) {
                score = ((Float)group.sortValues[scorePos]).floatValue();
            }
            docs[pos] = new FieldDoc(col.topDoc, score, group.sortValues);
            collapseValues[pos] = group.groupValue;
            ++pos;
        }
        return new CollapseTopFieldDocs(this.collapseField, this.totalHitCount, (ScoreDoc[])docs, this.sort.getSort(), collapseValues, this.maxScore);
    }

    public boolean needsScores() {
        if (!super.needsScores()) {
            return this.trackMaxScore;
        }
        return true;
    }

    public void setScorer(Scorer scorer) throws IOException {
        super.setScorer(scorer);
        this.scorer = scorer;
    }

    public void collect(int doc) throws IOException {
        super.collect(doc);
        if (this.trackMaxScore) {
            this.maxScore = Math.max(this.maxScore, this.scorer.score());
        }
        ++this.totalHitCount;
    }

    public static CollapsingTopDocsCollector<?> createNumeric(String collapseField, Sort sort, int topN, boolean trackMaxScore) {
        return new CollapsingTopDocsCollector<Long>(new CollapsingDocValuesSource.Numeric(collapseField), collapseField, sort, topN, trackMaxScore);
    }

    public static CollapsingTopDocsCollector<?> createKeyword(String collapseField, Sort sort, int topN, boolean trackMaxScore) {
        return new CollapsingTopDocsCollector<BytesRef>(new CollapsingDocValuesSource.Keyword(collapseField), collapseField, sort, topN, trackMaxScore);
    }
}

