/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLHoldInstructionExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_holdInstructionCode;
    private ASN1ObjectID holdInstruction = null;

    public CRLHoldInstructionExtension() {
        super(TYPE);
    }

    public CRLHoldInstructionExtension(ASN1ObjectID holdInstruction) {
        this(holdInstruction, false);
    }

    public CRLHoldInstructionExtension(ASN1ObjectID holdInstruction, boolean critical) {
        super(TYPE, critical);
        this.holdInstruction = holdInstruction;
        this.setValue(this.toByteArray());
    }

    public CRLHoldInstructionExtension(InputStream is) throws IOException {
        super(is);
    }

    public ASN1ObjectID getHoldInstruction() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.holdInstruction;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)this.holdInstruction);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.holdInstruction = new ASN1ObjectID((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLHoldInstructionExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getHoldInstruction() + "}";
    }
}

