/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;

class GateNotificationHelper
implements AutoCloseable {
    private final InputGate inputGate;
    private final Object availabilityMonitor;
    private CompletableFuture<?> toNotifyPriority;
    private CompletableFuture<?> toNotify;

    public GateNotificationHelper(InputGate inputGate, Object availabilityMonitor) {
        this.inputGate = inputGate;
        this.availabilityMonitor = availabilityMonitor;
    }

    @Override
    public void close() {
        if (this.toNotifyPriority != null) {
            this.toNotifyPriority.complete(null);
        }
        if (this.toNotify != null) {
            this.toNotify.complete(null);
        }
    }

    public void notifyPriority() {
        this.toNotifyPriority = this.inputGate.priorityAvailabilityHelper.getUnavailableToResetAvailable();
    }

    public void notifyDataAvailable() {
        this.availabilityMonitor.notifyAll();
        this.toNotify = this.inputGate.availabilityHelper.getUnavailableToResetAvailable();
    }
}

