/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.SortedMap;
import org.apache.flink.api.common.typeutils.NestedSerializersSnapshotDelegate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.runtime.typeutils.SortedMapSerializer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class SortedMapSerializerSnapshot<K, V>
implements TypeSerializerSnapshot<SortedMap<K, V>> {
    private Comparator<K> comparator;
    private NestedSerializersSnapshotDelegate nestedSerializersSnapshotDelegate;
    private static final int CURRENT_VERSION = 3;

    public SortedMapSerializerSnapshot() {
    }

    SortedMapSerializerSnapshot(SortedMapSerializer<K, V> sortedMapSerializer) {
        this.comparator = sortedMapSerializer.getComparator();
        TypeSerializer[] typeSerializers = new TypeSerializer[]{sortedMapSerializer.getKeySerializer(), sortedMapSerializer.getValueSerializer()};
        this.nestedSerializersSnapshotDelegate = new NestedSerializersSnapshotDelegate(typeSerializers);
    }

    public int getCurrentVersion() {
        return 3;
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkState((this.comparator != null ? 1 : 0) != 0, (Object)"Comparator cannot be null.");
        InstantiationUtil.serializeObject((OutputStream)new DataOutputViewStream(out), this.comparator);
        this.nestedSerializersSnapshotDelegate.writeNestedSerializerSnapshots(out);
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        try {
            this.comparator = (Comparator)InstantiationUtil.deserializeObject((InputStream)new DataInputViewStream(in), (ClassLoader)userCodeClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.nestedSerializersSnapshotDelegate = NestedSerializersSnapshotDelegate.readNestedSerializerSnapshots((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }

    public SortedMapSerializer restoreSerializer() {
        TypeSerializer[] nestedSerializers = this.nestedSerializersSnapshotDelegate.getRestoredNestedSerializers();
        TypeSerializer keySerializer = nestedSerializers[0];
        TypeSerializer valueSerializer = nestedSerializers[1];
        return new SortedMapSerializer(this.comparator, keySerializer, valueSerializer);
    }

    public TypeSerializerSchemaCompatibility<SortedMap<K, V>> resolveSchemaCompatibility(TypeSerializer<SortedMap<K, V>> newSerializer) {
        if (!(newSerializer instanceof SortedMapSerializer)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        SortedMapSerializer newSortedMapSerializer = (SortedMapSerializer)newSerializer;
        if (!this.comparator.equals(newSortedMapSerializer.getComparator())) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        return TypeSerializerSchemaCompatibility.compatibleAsIs();
    }
}

