/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStatusHolder {
    private static final Logger logger = LoggerFactory.getLogger(ServiceStatusHolder.class);
    private static final AtomicBoolean isServiceStopped = new AtomicBoolean(false);
    private static final AtomicBoolean isReadStopped = new AtomicBoolean(false);
    private static final AtomicBoolean isWriteStopped = new AtomicBoolean(false);
    private static int allowedReadIOExcptCnt = 10;
    private static int allowedWriteIOExcptCnt = 10;
    private static long statsDurationMs = 120000L;
    private static final AtomicLong curReadIOExcptCnt = new AtomicLong(0L);
    private static final AtomicLong lastReadStatsTime = new AtomicLong(System.currentTimeMillis());
    private static final AtomicBoolean isPauseRead = new AtomicBoolean(false);
    private static final AtomicLong curWriteIOExcptCnt = new AtomicLong(0L);
    private static final AtomicLong lastWriteStatsTime = new AtomicLong(System.currentTimeMillis());
    private static final AtomicBoolean isPauseWrite = new AtomicBoolean(false);

    public static void setStatsParameters(int paraAllowedReadIOExcptCnt, int paraAllowedWriteIOExcptCnt, long paraStatsDurationMs) {
        allowedReadIOExcptCnt = paraAllowedReadIOExcptCnt;
        allowedWriteIOExcptCnt = paraAllowedWriteIOExcptCnt;
        statsDurationMs = paraStatsDurationMs;
    }

    public static boolean isServiceStopped() {
        return isServiceStopped.get();
    }

    public static void setStoppedStatus(boolean isStopped, String caller) {
        if (isServiceStopped.get() != isStopped) {
            isServiceStopped.set(isStopped);
            if (isStopped) {
                logger.warn(new StringBuilder(256).append("[Service Status]: global-write stopped by caller ").append(caller).toString());
            }
        }
    }

    public static boolean addWriteIOErrCnt() {
        if (curWriteIOExcptCnt.incrementAndGet() > (long)allowedWriteIOExcptCnt) {
            if (isPauseWrite.get()) {
                return true;
            }
            isPauseWrite.set(true);
            return true;
        }
        return false;
    }

    public static boolean isWriteServiceStop() {
        return isPauseWrite.get() || isWriteStopped.get();
    }

    public static int getWriteServiceReportStatus() {
        return ServiceStatusHolder.getCurServiceStatus(isPauseWrite.get(), isWriteStopped.get());
    }

    public static boolean addReadIOErrCnt() {
        if (curReadIOExcptCnt.incrementAndGet() > (long)allowedReadIOExcptCnt) {
            if (isPauseRead.get()) {
                return true;
            }
            isPauseRead.set(true);
            return true;
        }
        return false;
    }

    public static boolean isReadServiceStop() {
        return isPauseRead.get() || isReadStopped.get();
    }

    public static int getReadServiceReportStatus() {
        return ServiceStatusHolder.getCurServiceStatus(isPauseRead.get(), isReadStopped.get());
    }

    public static void setReadWriteServiceStatus(boolean isReadStop, boolean isWriteStop, String caller) {
        if (isReadStopped.get() != isReadStop) {
            isReadStopped.set(isReadStop);
            if (isReadStop) {
                logger.warn(new StringBuilder(256).append("[Service Status]: global-read stopped by caller ").append(caller).toString());
            } else {
                if (isPauseRead.get()) {
                    isPauseRead.set(false);
                    curReadIOExcptCnt.set(0L);
                    lastReadStatsTime.set(System.currentTimeMillis());
                }
                logger.warn(new StringBuilder(256).append("[Service Status]: global-read opened by caller ").append(caller).toString());
            }
        }
        if (isWriteStopped.get() != isWriteStop) {
            isWriteStopped.set(isWriteStop);
            if (isWriteStop) {
                logger.warn(new StringBuilder(256).append("[Service Status]: global-write stopped by caller ").append(caller).toString());
            } else {
                if (isPauseWrite.get()) {
                    isPauseWrite.set(false);
                    curWriteIOExcptCnt.set(0L);
                    lastWriteStatsTime.set(System.currentTimeMillis());
                }
                logger.warn(new StringBuilder(256).append("[Service Status]: global-write opened by caller ").append(caller).toString());
            }
        }
    }

    private static int getCurServiceStatus(boolean pauseStatus, boolean serviceStatus) {
        if (serviceStatus) {
            return 1;
        }
        if (pauseStatus) {
            return -1;
        }
        return 0;
    }
}

