/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregator;

public class PatternAggregators {
    private PatternAggregator[][] values;
    private final List<PatternAggregator> patternAggregators;

    public PatternAggregators(int capacity, List<PatternAggregator> patternAggregators) {
        this.values = new PatternAggregator[capacity][];
        this.patternAggregators = patternAggregators;
    }

    public PatternAggregator[] get(int key) {
        if (this.values[key] == null) {
            PatternAggregator[] aggregations = new PatternAggregator[this.patternAggregators.size()];
            for (int i = 0; i < this.patternAggregators.size(); ++i) {
                aggregations[i] = this.patternAggregators.get(i);
                this.values[key] = aggregations;
            }
        }
        return this.values[key];
    }

    public void release(int key) {
        if (this.values[key] != null) {
            this.values[key] = null;
        }
    }

    public void copy(int parent, int child) {
        this.ensureCapacity(child);
        Preconditions.checkState((this.values[child] == null ? 1 : 0) != 0, (Object)"overriding aggregations for child thread");
        if (this.values[parent] != null) {
            PatternAggregator[] aggregations = new PatternAggregator[this.patternAggregators.size()];
            for (int i = 0; i < this.patternAggregators.size(); ++i) {
                aggregations[i] = this.values[parent][i].copy();
                this.values[child] = aggregations;
            }
        }
    }

    private void ensureCapacity(int key) {
        if (key >= this.values.length) {
            this.values = (PatternAggregator[][])Arrays.copyOf(this.values, Math.max(this.values.length * 2, key + 1));
        }
    }
}

