/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanNodeDecorrelator;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class TransformCorrelatedJoinToJoin
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation()));
    private final PlannerContext plannerContext;

    public TransformCorrelatedJoinToJoin(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((correlatedJoinNode.getJoinType() == JoinNode.JoinType.INNER || correlatedJoinNode.getJoinType() == JoinNode.JoinType.LEFT ? 1 : 0) != 0, (String)"correlation in %s JOIN", (Object)correlatedJoinNode.getJoinType().name());
        PlanNode subquery = correlatedJoinNode.getSubquery();
        PlanNodeDecorrelator planNodeDecorrelator = new PlanNodeDecorrelator(this.plannerContext, context.getSymbolAllocator(), context.getLookup());
        Optional<PlanNodeDecorrelator.DecorrelatedNode> decorrelatedNodeOptional = planNodeDecorrelator.decorrelateFilters(subquery, correlatedJoinNode.getCorrelation());
        if (!decorrelatedNodeOptional.isPresent()) {
            return Rule.Result.empty();
        }
        PlanNodeDecorrelator.DecorrelatedNode decorrelatedSubquery = decorrelatedNodeOptional.get();
        Expression filter = IrUtils.combineConjuncts(decorrelatedSubquery.getCorrelatedPredicates().orElse(BooleanLiteral.TRUE_LITERAL), correlatedJoinNode.getFilter());
        return Rule.Result.ofPlanNode(new JoinNode(correlatedJoinNode.getPlanNodeId(), correlatedJoinNode.getJoinType(), correlatedJoinNode.getInput(), decorrelatedSubquery.getNode(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), Optional.empty(), correlatedJoinNode.getInput().getOutputSymbols(), correlatedJoinNode.getSubquery().getOutputSymbols(), filter.equals(BooleanLiteral.TRUE_LITERAL) ? Optional.empty() : Optional.of(filter), Optional.empty()));
    }
}

