/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.source;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorTreePlan;

public class PipeConfigPhysicalPlanTreeScopeParseVisitor
extends ConfigPhysicalPlanVisitor<Optional<ConfigPhysicalPlan>, Void> {
    @Override
    public Optional<ConfigPhysicalPlan> visitPlan(ConfigPhysicalPlan plan, Void context) {
        return Optional.of(plan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitGrantRole(AuthorTreePlan grantRolePlan, Void context) {
        return this.visitTreeAuthorPlan(grantRolePlan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitGrantUser(AuthorTreePlan grantUserPlan, Void context) {
        return this.visitTreeAuthorPlan(grantUserPlan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRevokeUser(AuthorTreePlan revokeUserPlan, Void context) {
        return this.visitTreeAuthorPlan(revokeUserPlan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRevokeRole(AuthorTreePlan revokeRolePlan, Void context) {
        return this.visitTreeAuthorPlan(revokeRolePlan);
    }

    private Optional<ConfigPhysicalPlan> visitTreeAuthorPlan(AuthorTreePlan authorTreePlan) {
        Set<Integer> permissions = authorTreePlan.getPermissions().stream().filter(permission -> PrivilegeType.values()[permission].forRelationalSys()).collect(Collectors.toSet());
        return !permissions.isEmpty() ? Optional.of(new AuthorTreePlan(authorTreePlan.getAuthorType(), authorTreePlan.getUserName(), authorTreePlan.getRoleName(), authorTreePlan.getPassword(), authorTreePlan.getNewPassword(), permissions, authorTreePlan.getGrantOpt(), authorTreePlan.getNodeNameList())) : Optional.empty();
    }
}

