/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.file.IMetadataIndexEntry;
import org.apache.tsfile.file.metadata.DeviceMetadataIndexEntry;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MeasurementMetadataIndexEntry;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.tsfile.write.writer.TsFileOutput;

public class MetadataIndexConstructor {
    private static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();

    private MetadataIndexConstructor() {
        throw new IllegalStateException("Utility class");
    }

    public static MetadataIndexNode constructMetadataIndex(Map<IDeviceID, List<TimeseriesMetadata>> deviceTimeseriesMetadataMap, TsFileOutput out) throws IOException {
        TreeMap<IDeviceID, MetadataIndexNode> deviceMetadataIndexMap = new TreeMap<IDeviceID, MetadataIndexNode>();
        for (Map.Entry<IDeviceID, List<TimeseriesMetadata>> entry : deviceTimeseriesMetadataMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ArrayDeque<MetadataIndexNode> measurementMetadataIndexQueue = new ArrayDeque<MetadataIndexNode>();
            MetadataIndexNode currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
            for (int i = 0; i < entry.getValue().size(); ++i) {
                TimeseriesMetadata timeseriesMetadata = entry.getValue().get(i);
                if (i % config.getMaxDegreeOfIndexNode() == 0) {
                    if (currentIndexNode.isFull()) {
                        MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, out);
                        currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
                    }
                    currentIndexNode.addEntry(new MeasurementMetadataIndexEntry(timeseriesMetadata.getMeasurementId(), out.getPosition()));
                }
                timeseriesMetadata.serializeTo(out.wrapAsStream());
            }
            MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, out);
            deviceMetadataIndexMap.put(entry.getKey(), MetadataIndexConstructor.generateRootNode(measurementMetadataIndexQueue, out, MetadataIndexNodeType.INTERNAL_MEASUREMENT));
        }
        return MetadataIndexConstructor.checkAndBuildLevelIndex(deviceMetadataIndexMap, out);
    }

    public static Map<String, Map<IDeviceID, MetadataIndexNode>> splitDeviceByTable(Map<IDeviceID, MetadataIndexNode> deviceMetadataIndexMap) {
        TreeMap<String, Map<IDeviceID, MetadataIndexNode>> result = new TreeMap<String, Map<IDeviceID, MetadataIndexNode>>();
        for (Map.Entry<IDeviceID, MetadataIndexNode> entry : deviceMetadataIndexMap.entrySet()) {
            IDeviceID deviceID = entry.getKey();
            String tableName = deviceID.getTableName();
            result.computeIfAbsent(tableName, tName -> new TreeMap()).put(deviceID, entry.getValue());
        }
        return result;
    }

    public static MetadataIndexNode checkAndBuildLevelIndex(Map<IDeviceID, MetadataIndexNode> deviceMetadataIndexMap, TsFileOutput out) throws IOException {
        if (deviceMetadataIndexMap.size() <= config.getMaxDegreeOfIndexNode()) {
            MetadataIndexNode metadataIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_DEVICE);
            for (Map.Entry<IDeviceID, MetadataIndexNode> entry : deviceMetadataIndexMap.entrySet()) {
                metadataIndexNode.addEntry(new DeviceMetadataIndexEntry(entry.getKey(), out.getPosition()));
                entry.getValue().serializeTo(out.wrapAsStream());
            }
            metadataIndexNode.setEndOffset(out.getPosition());
            return metadataIndexNode;
        }
        ArrayDeque<MetadataIndexNode> deviceMetadataIndexQueue = new ArrayDeque<MetadataIndexNode>();
        MetadataIndexNode currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_DEVICE);
        for (Map.Entry<IDeviceID, MetadataIndexNode> entry : deviceMetadataIndexMap.entrySet()) {
            if (currentIndexNode.isFull()) {
                MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, deviceMetadataIndexQueue, out);
                currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_DEVICE);
            }
            currentIndexNode.addEntry(new DeviceMetadataIndexEntry(entry.getKey(), out.getPosition()));
            entry.getValue().serializeTo(out.wrapAsStream());
        }
        MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, deviceMetadataIndexQueue, out);
        MetadataIndexNode deviceMetadataIndexNode = MetadataIndexConstructor.generateRootNode(deviceMetadataIndexQueue, out, MetadataIndexNodeType.INTERNAL_DEVICE);
        deviceMetadataIndexNode.setEndOffset(out.getPosition());
        return deviceMetadataIndexNode;
    }

    public static MetadataIndexNode generateRootNode(Queue<MetadataIndexNode> metadataIndexNodeQueue, TsFileOutput out, MetadataIndexNodeType type) throws IOException {
        int queueSize = metadataIndexNodeQueue.size();
        MetadataIndexNode currentIndexNode = new MetadataIndexNode(type);
        while (queueSize != 1) {
            for (int i = 0; i < queueSize; ++i) {
                MetadataIndexNode metadataIndexNode = metadataIndexNodeQueue.poll();
                if (currentIndexNode.isFull()) {
                    MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, metadataIndexNodeQueue, out);
                    currentIndexNode = new MetadataIndexNode(type);
                }
                IMetadataIndexEntry entry = null;
                entry = metadataIndexNode.isDeviceLevel() ? new DeviceMetadataIndexEntry(((DeviceMetadataIndexEntry)metadataIndexNode.peek()).getDeviceID(), out.getPosition()) : new MeasurementMetadataIndexEntry(((MeasurementMetadataIndexEntry)metadataIndexNode.peek()).getName(), out.getPosition());
                currentIndexNode.addEntry(entry);
                metadataIndexNode.serializeTo(out.wrapAsStream());
            }
            MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, metadataIndexNodeQueue, out);
            currentIndexNode = new MetadataIndexNode(type);
            queueSize = metadataIndexNodeQueue.size();
        }
        return metadataIndexNodeQueue.poll();
    }

    public static void addCurrentIndexNodeToQueue(MetadataIndexNode currentIndexNode, Queue<MetadataIndexNode> metadataIndexNodeQueue, TsFileOutput out) throws IOException {
        currentIndexNode.setEndOffset(out.getPosition());
        metadataIndexNodeQueue.add(currentIndexNode);
    }
}

