/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.query.dataset;

import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.query.dataset.AbstractResultSet;
import org.apache.tsfile.read.reader.block.TsBlockReader;
import org.apache.tsfile.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableResultSet
extends AbstractResultSet {
    private static final Logger LOG = LoggerFactory.getLogger(TableResultSet.class);
    private final TsBlockReader tsBlockReader;
    private TsBlock currentTsBlock;
    private int currentTsBlockIndex;

    public TableResultSet(TsBlockReader tsBlockReader, List<String> columnNameList, List<TSDataType> dataTypeList) {
        super(columnNameList, dataTypeList);
        this.tsBlockReader = tsBlockReader;
    }

    @Override
    public boolean next() throws IOException {
        while ((this.currentTsBlock == null || this.currentTsBlockIndex >= this.currentTsBlock.getPositionCount() - 1) && this.tsBlockReader.hasNext()) {
            this.currentTsBlock = this.tsBlockReader.next();
            this.currentTsBlockIndex = -1;
        }
        ++this.currentTsBlockIndex;
        return this.currentTsBlock != null && this.currentTsBlockIndex < this.currentTsBlock.getPositionCount();
    }

    @Override
    public int getInt(int columnIndex) {
        return this.currentTsBlock.getValueColumns()[columnIndex - 2].getInt(this.currentTsBlockIndex);
    }

    @Override
    public long getLong(int columnIndex) {
        return columnIndex == 1 ? this.currentTsBlock.getTimeByIndex(this.currentTsBlockIndex) : this.currentTsBlock.getValueColumns()[columnIndex - 2].getLong(this.currentTsBlockIndex);
    }

    @Override
    public double getDouble(int columnIndex) {
        return this.currentTsBlock.getValueColumns()[columnIndex - 2].getDouble(this.currentTsBlockIndex);
    }

    @Override
    public float getFloat(int columnIndex) {
        return this.currentTsBlock.getValueColumns()[columnIndex - 2].getFloat(this.currentTsBlockIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        return this.currentTsBlock.getValueColumns()[columnIndex - 2].getBoolean(this.currentTsBlockIndex);
    }

    @Override
    public LocalDate getDate(int columnIndex) {
        return DateUtils.parseIntToLocalDate(this.currentTsBlock.getValueColumns()[columnIndex - 2].getInt(this.currentTsBlockIndex));
    }

    @Override
    public byte[] getBinary(int columnIndex) {
        return this.currentTsBlock.getValueColumns()[columnIndex - 2].getBinary(this.currentTsBlockIndex).getValues();
    }

    @Override
    public String getString(int columnIndex) {
        return this.currentTsBlock.getValueColumns()[columnIndex - 2].getBinary(this.currentTsBlockIndex).toString();
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.currentTsBlock.getValueColumns()[columnIndex - 2].isNull(this.currentTsBlockIndex);
    }

    @Override
    public void close() {
        if (this.tsBlockReader == null) {
            return;
        }
        try {
            this.tsBlockReader.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close tsBlockReader");
        }
    }
}

