/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.db.pipe.receiver.protocol.thrift.IoTDBDataNodeReceiver;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferTabletBinaryReq
extends TPipeTransferReq {
    protected transient ByteBuffer byteBuffer;

    protected PipeTransferTabletBinaryReq() {
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public InsertBaseStatement constructStatement() {
        InsertNode insertNode = this.parseByteBuffer();
        if (!(insertNode instanceof InsertRowNode || insertNode instanceof InsertTabletNode || insertNode instanceof InsertRowsNode)) {
            throw new UnsupportedOperationException(String.format("Unknown InsertNode type %s when constructing statement from insert node.", insertNode));
        }
        return (InsertBaseStatement)IoTDBDataNodeReceiver.PLAN_TO_STATEMENT_VISITOR.process(insertNode, null);
    }

    protected InsertNode parseByteBuffer() {
        PlanNode node = WALEntry.deserializeForConsensus(this.byteBuffer);
        return node instanceof InsertNode ? (InsertNode)node : null;
    }

    public static PipeTransferTabletBinaryReq toTPipeTransferReq(ByteBuffer byteBuffer) {
        PipeTransferTabletBinaryReq req = new PipeTransferTabletBinaryReq();
        req.byteBuffer = byteBuffer;
        req.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_BINARY.getType();
        req.body = byteBuffer;
        return req;
    }

    public static PipeTransferTabletBinaryReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletBinaryReq binaryReq = new PipeTransferTabletBinaryReq();
        binaryReq.byteBuffer = transferReq.body;
        binaryReq.version = transferReq.version;
        binaryReq.type = transferReq.type;
        return binaryReq;
    }

    public static byte[] toTPipeTransferBytes(ByteBuffer byteBuffer) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBSinkRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_BINARY.getType(), (OutputStream)outputStream);
                byArray = BytesUtils.concatByteArray((byte[])byteArrayOutputStream.toByteArray(), (byte[])byteBuffer.array());
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletBinaryReq that = (PipeTransferTabletBinaryReq)((Object)obj);
        return this.byteBuffer.equals(that.byteBuffer) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.byteBuffer, this.version, this.type, this.body);
    }
}

