/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum RowsPerMatch {
    ONE{

        @Override
        public boolean isOneRow() {
            return true;
        }

        @Override
        public boolean isEmptyMatches() {
            return true;
        }

        @Override
        public boolean isUnmatchedRows() {
            return false;
        }
    }
    ,
    ALL_SHOW_EMPTY{

        @Override
        public boolean isOneRow() {
            return false;
        }

        @Override
        public boolean isEmptyMatches() {
            return true;
        }

        @Override
        public boolean isUnmatchedRows() {
            return false;
        }
    }
    ,
    ALL_OMIT_EMPTY{

        @Override
        public boolean isOneRow() {
            return false;
        }

        @Override
        public boolean isEmptyMatches() {
            return false;
        }

        @Override
        public boolean isUnmatchedRows() {
            return false;
        }
    }
    ,
    ALL_WITH_UNMATCHED{

        @Override
        public boolean isOneRow() {
            return false;
        }

        @Override
        public boolean isEmptyMatches() {
            return true;
        }

        @Override
        public boolean isUnmatchedRows() {
            return true;
        }
    };


    public abstract boolean isOneRow();

    public abstract boolean isEmptyMatches();

    public abstract boolean isUnmatchedRows();

    public static void serialize(RowsPerMatch rowsPerMatch, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)rowsPerMatch.ordinal(), (ByteBuffer)byteBuffer);
    }

    public static void serialize(RowsPerMatch rowsPerMatch, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)rowsPerMatch.ordinal(), (OutputStream)stream);
    }

    public static RowsPerMatch deserialize(ByteBuffer byteBuffer) {
        int ordinal = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        return RowsPerMatch.values()[ordinal];
    }
}

