/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.tsfile.read.reader.TsFileInput;
import org.apache.tsfile.utils.Preconditions;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.writer.LocalTsFileOutput;
import org.apache.tsfile.write.writer.tsmiterator.TSMIterator;

public class TimeseriesMetadata
implements ITimeSeriesMetadata {
    private static final int INSTANCE_SIZE = (int)(RamUsageEstimator.shallowSizeOfInstance(TimeseriesMetadata.class) + RamUsageEstimator.shallowSizeOfInstance(String.class) + RamUsageEstimator.shallowSizeOfInstance(TSDataType.class) + RamUsageEstimator.shallowSizeOfInstance(ArrayList.class));
    private byte timeSeriesMetadataType;
    private int chunkMetaDataListDataSize;
    private String measurementId;
    private TSDataType dataType;
    private Statistics<? extends Serializable> statistics;
    private boolean modified;
    private IChunkMetadataLoader chunkMetadataLoader;
    private boolean isSeq = true;
    private PublicBAOS chunkMetadataListBuffer;
    private ArrayList<IChunkMetadata> chunkMetadataList;

    public TimeseriesMetadata() {
    }

    public TimeseriesMetadata(byte timeSeriesMetadataType, int chunkMetaDataListDataSize, String measurementId, TSDataType dataType, Statistics<? extends Serializable> statistics, PublicBAOS chunkMetadataListBuffer) {
        this.timeSeriesMetadataType = timeSeriesMetadataType;
        this.chunkMetaDataListDataSize = chunkMetaDataListDataSize;
        this.measurementId = measurementId;
        this.dataType = dataType;
        this.statistics = statistics;
        this.chunkMetadataListBuffer = chunkMetadataListBuffer;
    }

    public TimeseriesMetadata(TimeseriesMetadata timeseriesMetadata) {
        this.timeSeriesMetadataType = timeseriesMetadata.timeSeriesMetadataType;
        this.chunkMetaDataListDataSize = timeseriesMetadata.chunkMetaDataListDataSize;
        this.measurementId = timeseriesMetadata.measurementId;
        this.dataType = timeseriesMetadata.dataType;
        this.statistics = timeseriesMetadata.statistics;
        this.modified = timeseriesMetadata.modified;
        this.chunkMetadataList = timeseriesMetadata.chunkMetadataList;
    }

    public static TimeseriesMetadata deserializeFrom(ByteBuffer buffer, boolean needChunkMetadata) {
        return TimeseriesMetadata.deserializeFrom(buffer, needChunkMetadata, needChunkMetadata);
    }

    public static TimeseriesMetadata deserializeFrom(ByteBuffer buffer, boolean needChunkMetadataForNonBlob, boolean needChunkMetadataForBlob) {
        TimeseriesMetadata timeseriesMetaData = new TimeseriesMetadata();
        timeseriesMetaData.setTimeSeriesMetadataType(ReadWriteIOUtils.readByte(buffer));
        timeseriesMetaData.setMeasurementId(ReadWriteIOUtils.readVarIntString(buffer));
        timeseriesMetaData.setTsDataType(ReadWriteIOUtils.readDataType(buffer));
        int chunkMetaDataListDataSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        timeseriesMetaData.setDataSizeOfChunkMetaDataList(chunkMetaDataListDataSize);
        timeseriesMetaData.setStatistics(Statistics.deserialize(buffer, timeseriesMetaData.dataType));
        if (timeseriesMetaData.getTsDataType() != TSDataType.BLOB && needChunkMetadataForNonBlob || timeseriesMetaData.getTsDataType() == TSDataType.BLOB && needChunkMetadataForBlob) {
            ByteBuffer byteBuffer = buffer.slice();
            byteBuffer.limit(chunkMetaDataListDataSize);
            timeseriesMetaData.chunkMetadataList = new ArrayList();
            while (byteBuffer.hasRemaining()) {
                timeseriesMetaData.chunkMetadataList.add(ChunkMetadata.deserializeFrom(byteBuffer, timeseriesMetaData));
            }
            timeseriesMetaData.chunkMetadataList.trimToSize();
        }
        buffer.position(buffer.position() + chunkMetaDataListDataSize);
        return timeseriesMetaData;
    }

    public static TimeseriesMetadata deserializeFrom(TsFileInput tsFileInput, boolean needChunkMetadata) throws IOException {
        return TimeseriesMetadata.deserializeFrom(tsFileInput, needChunkMetadata, needChunkMetadata);
    }

    public static TimeseriesMetadata deserializeFrom(TsFileInput tsFileInput, boolean needChunkMetadataForNonBlob, boolean needChunkMetadataForBlob) throws IOException {
        InputStream inputStream = tsFileInput.wrapAsInputStream();
        TimeseriesMetadata timeseriesMetaData = new TimeseriesMetadata();
        timeseriesMetaData.setTimeSeriesMetadataType(ReadWriteIOUtils.readByte(inputStream));
        timeseriesMetaData.setMeasurementId(ReadWriteIOUtils.readVarIntString(inputStream));
        timeseriesMetaData.setTsDataType(ReadWriteIOUtils.readDataType(inputStream));
        int chunkMetaDataListDataSize = ReadWriteForEncodingUtils.readUnsignedVarInt(inputStream);
        timeseriesMetaData.setDataSizeOfChunkMetaDataList(chunkMetaDataListDataSize);
        timeseriesMetaData.setStatistics(Statistics.deserialize(inputStream, timeseriesMetaData.dataType));
        long startOffset = tsFileInput.position();
        if (timeseriesMetaData.getTsDataType() != TSDataType.BLOB && needChunkMetadataForNonBlob || timeseriesMetaData.getTsDataType() == TSDataType.BLOB && needChunkMetadataForBlob) {
            timeseriesMetaData.chunkMetadataList = new ArrayList();
            while (tsFileInput.position() < startOffset + (long)chunkMetaDataListDataSize) {
                timeseriesMetaData.chunkMetadataList.add(ChunkMetadata.deserializeFrom(inputStream, timeseriesMetaData));
            }
            timeseriesMetaData.chunkMetadataList.trimToSize();
        } else {
            tsFileInput.position(startOffset + (long)chunkMetaDataListDataSize);
        }
        return timeseriesMetaData;
    }

    public static TimeseriesMetadata deserializeFrom(ByteBuffer buffer, Set<String> excludedMeasurements, boolean needChunkMetadata) {
        return TimeseriesMetadata.deserializeFrom(buffer, excludedMeasurements, needChunkMetadata, needChunkMetadata);
    }

    public static TimeseriesMetadata deserializeFrom(ByteBuffer buffer, Set<String> excludedMeasurements, boolean needChunkMetadataForNonBlob, boolean needChunkMetadataForBlob) {
        byte timeseriesType = ReadWriteIOUtils.readByte(buffer);
        String measurementID = ReadWriteIOUtils.readVarIntString(buffer);
        TSDataType tsDataType = ReadWriteIOUtils.readDataType(buffer);
        int chunkMetaDataListDataSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        Statistics<Serializable> statistics = Statistics.deserialize(buffer, tsDataType);
        TimeseriesMetadata timeseriesMetaData = new TimeseriesMetadata();
        timeseriesMetaData.setMeasurementId(measurementID);
        timeseriesMetaData.setTimeSeriesMetadataType(timeseriesType);
        timeseriesMetaData.setTsDataType(tsDataType);
        timeseriesMetaData.setDataSizeOfChunkMetaDataList(chunkMetaDataListDataSize);
        timeseriesMetaData.setStatistics(statistics);
        if (!excludedMeasurements.contains(measurementID) && (tsDataType != TSDataType.BLOB && needChunkMetadataForNonBlob || tsDataType == TSDataType.BLOB && needChunkMetadataForBlob)) {
            ByteBuffer byteBuffer = buffer.slice();
            byteBuffer.limit(chunkMetaDataListDataSize);
            timeseriesMetaData.chunkMetadataList = new ArrayList();
            while (byteBuffer.hasRemaining()) {
                timeseriesMetaData.chunkMetadataList.add(ChunkMetadata.deserializeFrom(byteBuffer, timeseriesMetaData));
            }
            timeseriesMetaData.chunkMetadataList.trimToSize();
        }
        buffer.position(buffer.position() + chunkMetaDataListDataSize);
        return timeseriesMetaData;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.timeSeriesMetadataType, outputStream);
        byteLen += ReadWriteIOUtils.writeVar(this.measurementId, outputStream);
        byteLen += ReadWriteIOUtils.write(this.dataType, outputStream);
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.chunkMetaDataListDataSize, outputStream);
        byteLen += this.statistics.serialize(outputStream);
        this.chunkMetadataListBuffer.writeTo(outputStream);
        return byteLen += this.chunkMetadataListBuffer.size();
    }

    public byte getTimeSeriesMetadataType() {
        return this.timeSeriesMetadataType;
    }

    public void setTimeSeriesMetadataType(byte timeSeriesMetadataType) {
        this.timeSeriesMetadataType = timeSeriesMetadataType;
    }

    public String getMeasurementId() {
        return this.measurementId;
    }

    public void setMeasurementId(String measurementId) {
        this.measurementId = measurementId;
    }

    public int getDataSizeOfChunkMetaDataList() {
        return this.chunkMetaDataListDataSize;
    }

    public void setDataSizeOfChunkMetaDataList(int size) {
        this.chunkMetaDataListDataSize = size;
    }

    public TSDataType getTsDataType() {
        return this.dataType;
    }

    public void setTsDataType(TSDataType tsDataType) {
        this.dataType = tsDataType;
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics<? extends Serializable> statistics) {
        this.statistics = statistics;
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        Preconditions.checkArgument(measurementIndex == 0, "Non-aligned timeseries only has one measurement, but measurementIndex is " + measurementIndex);
        return Optional.ofNullable(this.statistics);
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        return false;
    }

    @Override
    public void setChunkMetadataLoader(IChunkMetadataLoader chunkMetadataLoader) {
        this.chunkMetadataLoader = chunkMetadataLoader;
    }

    @Override
    public boolean typeMatch(List<TSDataType> dataTypes) {
        return this.typeMatch(dataTypes.get(0));
    }

    public boolean typeMatch(TSDataType dataType) {
        return this.dataType == dataType;
    }

    @Override
    public List<IChunkMetadata> loadChunkMetadataList() {
        return this.chunkMetadataLoader.loadChunkMetadataList(this);
    }

    public List<IChunkMetadata> getChunkMetadataList() {
        return this.chunkMetadataList;
    }

    public List<IChunkMetadata> getCopiedChunkMetadataList() {
        ArrayList<IChunkMetadata> res = new ArrayList<IChunkMetadata>(this.chunkMetadataList.size());
        for (IChunkMetadata chunkMetadata : this.chunkMetadataList) {
            res.add(new ChunkMetadata((ChunkMetadata)chunkMetadata));
        }
        return res;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    @Override
    public boolean isSeq() {
        return this.isSeq;
    }

    public void setChunkMetadataListBuffer(PublicBAOS chunkMetadataListBuffer) {
        this.chunkMetadataListBuffer = chunkMetadataListBuffer;
    }

    public void setChunkMetadataList(List<ChunkMetadata> chunkMetadataList) {
        this.chunkMetadataList = new ArrayList<ChunkMetadata>(chunkMetadataList);
    }

    public long getRetainedSizeInBytes() {
        int length;
        long retainedSize = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfCharArray(this.measurementId.length()) + (this.statistics == null ? 0L : this.statistics.getRetainedSizeInBytes());
        int n = length = this.chunkMetadataList == null ? 0 : this.chunkMetadataList.size();
        if (length > 0) {
            retainedSize += RamUsageEstimator.sizeOfObjectArray(length);
            for (IChunkMetadata chunkMetadata : this.chunkMetadataList) {
                retainedSize += chunkMetadata == null ? 0L : ((ChunkMetadata)chunkMetadata).getRetainedSizeInBytes();
            }
        }
        return retainedSize;
    }

    public int serializedSizeWithoutMetadata() {
        byte[] bytes = this.measurementId.getBytes(TSFileConfig.STRING_CHARSET);
        return 1 + ReadWriteForEncodingUtils.varIntSize(bytes.length) + bytes.length + 1 + ReadWriteForEncodingUtils.uVarIntSize(this.chunkMetaDataListDataSize) + this.statistics.getSerializedSize();
    }

    public String toString() {
        return "TimeseriesMetadata{timeSeriesMetadataType=" + this.timeSeriesMetadataType + ", chunkMetaDataListDataSize=" + this.chunkMetaDataListDataSize + ", measurementId='" + this.measurementId + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", statistics=" + this.statistics + ", modified=" + this.modified + ", isSeq=" + this.isSeq + ", chunkMetadataList=" + this.chunkMetadataList + '}';
    }

    public static void main(String[] args) throws IOException {
        int deviceNum = 100;
        int measurementNum = 10000;
        ArrayList<TimeseriesMetadata> timeseriesMetadataList = new ArrayList<TimeseriesMetadata>(deviceNum * measurementNum);
        for (int i = 0; i < deviceNum; ++i) {
            for (int j = 0; j < measurementNum; ++j) {
                timeseriesMetadataList.add(TSMIterator.constructOneTimeseriesMetadata("s" + j, Collections.singletonList(new ChunkMetadata("s" + j, TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, 0L, Statistics.getStatsByType(TSDataType.INT64)))));
            }
        }
        long startTime = System.currentTimeMillis();
        int repeat = 100;
        for (int i = 0; i < repeat; ++i) {
            LocalTsFileOutput tsFileOutput = new LocalTsFileOutput(new FileOutputStream("test.tsfile"));
            for (int j = 0; j < timeseriesMetadataList.size(); ++j) {
                TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)timeseriesMetadataList.get(j);
                timeseriesMetadata.serializeTo(tsFileOutput);
            }
            tsFileOutput.close();
        }
        System.out.println(System.currentTimeMillis() - startTime);
    }
}

