/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;

public class ColumnList {
    private final List<Column> columns;
    private final List<Integer> positionCounts;

    public ColumnList(List<Column> columns) {
        this.columns = columns;
        this.positionCounts = new ArrayList<Integer>(columns.size());
        for (Column column : columns) {
            this.positionCounts.add(column.getPositionCount());
        }
    }

    public TSDataType getDataType() {
        return this.columns.get(0).getDataType();
    }

    public ColumnEncoding getEncoding() {
        return this.columns.get(0).getEncoding();
    }

    public ColumnListIndex getColumnListIndex(int rowIndex) {
        int columnIndex;
        for (columnIndex = 0; columnIndex < this.columns.size() && rowIndex >= this.positionCounts.get(columnIndex); rowIndex -= this.positionCounts.get(columnIndex).intValue(), ++columnIndex) {
        }
        if (columnIndex != this.columns.size()) {
            return new ColumnListIndex(columnIndex, rowIndex);
        }
        throw new IndexOutOfBoundsException("Index out of Partition's bounds!");
    }

    public boolean getBoolean(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).getBoolean(offsetInColumn);
    }

    public int getInt(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).getInt(offsetInColumn);
    }

    public long getLong(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).getLong(offsetInColumn);
    }

    public float getFloat(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).getFloat(offsetInColumn);
    }

    public double getDouble(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).getDouble(offsetInColumn);
    }

    public Binary getBinary(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).getBinary(offsetInColumn);
    }

    public Object getObject(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).getObject(offsetInColumn);
    }

    public boolean isNull(int position) {
        ColumnListIndex columnListIndex = this.getColumnListIndex(position);
        int columnIndex = columnListIndex.getColumnIndex();
        int offsetInColumn = columnListIndex.getOffsetInColumn();
        return this.columns.get(columnIndex).isNull(offsetInColumn);
    }

    public static class ColumnListIndex {
        private final int columnIndex;
        private final int offsetInColumn;

        ColumnListIndex(int columnIndex, int offsetInColumn) {
            this.columnIndex = columnIndex;
            this.offsetInColumn = offsetInColumn;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int getOffsetInColumn() {
            return this.offsetInColumn;
        }
    }
}

