/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

@ThreadSafe
public class TableDeviceLastCache {
    static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(TableDeviceLastCache.class) + (int)RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class);
    public static final TsPrimitiveType EMPTY_PRIMITIVE_TYPE = new TsPrimitiveType(){

        public void setObject(Object o) {
        }

        public void reset() {
        }

        public int getSize() {
            return 0;
        }

        public Object getValue() {
            return null;
        }

        public String getStringValue() {
            return null;
        }

        public TSDataType getDataType() {
            return null;
        }
    };
    private static final Optional<Pair<OptionalLong, TsPrimitiveType[]>> HIT_AND_ALL_NULL = Optional.of(new Pair((Object)OptionalLong.empty(), null));
    public static final TimeValuePair EMPTY_TIME_VALUE_PAIR = new TimeValuePair(Long.MIN_VALUE, EMPTY_PRIMITIVE_TYPE);
    private static final TimeValuePair PLACEHOLDER_TIME_VALUE_PAIR = new TimeValuePair(Long.MIN_VALUE, EMPTY_PRIMITIVE_TYPE);
    private final Map<String, TimeValuePair> measurement2CachedLastMap = new ConcurrentHashMap<String, TimeValuePair>();

    int initOrInvalidate(String database, String tableName, String[] measurements, boolean isInvalidate, boolean isTableModel) {
        AtomicInteger diff = new AtomicInteger(0);
        for (String measurement : measurements) {
            String finalMeasurement;
            String string = finalMeasurement = !this.measurement2CachedLastMap.containsKey(measurement) && isTableModel ? DataNodeTableCache.getInstance().tryGetInternColumnName(database, tableName, measurement) : measurement;
            if (Objects.isNull(finalMeasurement)) continue;
            TimeValuePair newPair = isInvalidate ? null : PLACEHOLDER_TIME_VALUE_PAIR;
            this.measurement2CachedLastMap.compute(finalMeasurement, (measurementKey, tvPair) -> {
                if (Objects.isNull(newPair)) {
                    diff.addAndGet(-((isTableModel ? 0 : (int)RamUsageEstimator.sizeOf((String)finalMeasurement)) + this.getTVPairEntrySize((TimeValuePair)tvPair)));
                    return null;
                }
                if (Objects.isNull(tvPair)) {
                    diff.addAndGet((isTableModel ? 0 : (int)RamUsageEstimator.sizeOf((String)finalMeasurement)) + (int)RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
                    return newPair;
                }
                return tvPair;
            });
        }
        return diff.get();
    }

    int tryUpdate(@Nonnull String[] measurements, @Nonnull TimeValuePair[] timeValuePairs) {
        return this.tryUpdate(measurements, timeValuePairs, false);
    }

    int tryUpdate(@Nonnull String[] measurements, @Nonnull TimeValuePair[] timeValuePairs, boolean invalidateNull) {
        AtomicInteger diff = new AtomicInteger(0);
        long lastTime = Long.MIN_VALUE;
        for (int i = 0; i < measurements.length; ++i) {
            if (Objects.isNull(timeValuePairs[i])) {
                if (!invalidateNull) continue;
                this.measurement2CachedLastMap.remove(measurements[i]);
                continue;
            }
            int finalI = i;
            if (lastTime < timeValuePairs[i].getTimestamp()) {
                lastTime = timeValuePairs[i].getTimestamp();
            }
            this.measurement2CachedLastMap.computeIfPresent(measurements[i], (measurement, tvPair) -> {
                if (tvPair.getTimestamp() <= timeValuePairs[finalI].getTimestamp()) {
                    diff.addAndGet(TableDeviceLastCache.getDiffSize(tvPair, timeValuePairs[finalI]));
                    return timeValuePairs[finalI];
                }
                return tvPair;
            });
        }
        long finalLastTime = lastTime;
        this.measurement2CachedLastMap.computeIfPresent("", (time, tvPair) -> tvPair.getTimestamp() < finalLastTime ? new TimeValuePair(finalLastTime, EMPTY_PRIMITIVE_TYPE) : tvPair);
        return diff.get();
    }

    @GuardedBy(value="DataRegionInsertLock#writeLock")
    int invalidate(String measurement, boolean isTableModel) {
        AtomicInteger diff = new AtomicInteger();
        AtomicLong time = new AtomicLong();
        this.measurement2CachedLastMap.computeIfPresent(measurement, (s, timeValuePair) -> {
            diff.set((isTableModel ? 0 : (int)RamUsageEstimator.sizeOf((String)s)) + this.getTVPairEntrySize((TimeValuePair)timeValuePair));
            time.set(timeValuePair.getTimestamp());
            return null;
        });
        if (diff.get() == 0) {
            return 0;
        }
        this.measurement2CachedLastMap.computeIfPresent("", (s, timeValuePair) -> {
            if (timeValuePair.getTimestamp() <= time.get()) {
                diff.addAndGet(this.getTVPairEntrySize((TimeValuePair)timeValuePair));
                return null;
            }
            return timeValuePair;
        });
        return diff.get();
    }

    private int getTVPairEntrySize(TimeValuePair tvPair) {
        return (int)RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + (Objects.isNull(tvPair) || tvPair == PLACEHOLDER_TIME_VALUE_PAIR || tvPair == EMPTY_TIME_VALUE_PAIR ? 0 : tvPair.getSize());
    }

    @Nullable
    TimeValuePair getTimeValuePair(@Nonnull String measurement) {
        TimeValuePair result = this.measurement2CachedLastMap.get(measurement);
        return result != PLACEHOLDER_TIME_VALUE_PAIR ? result : null;
    }

    Optional<Pair<OptionalLong, TsPrimitiveType[]>> getLastRow(@Nonnull String sourceMeasurement, List<String> targetMeasurements) {
        TimeValuePair pair = this.measurement2CachedLastMap.get(sourceMeasurement);
        if (Objects.isNull(pair) || pair == PLACEHOLDER_TIME_VALUE_PAIR) {
            return Optional.empty();
        }
        if (pair == EMPTY_TIME_VALUE_PAIR) {
            return HIT_AND_ALL_NULL;
        }
        long alignTime = pair.getTimestamp();
        return Optional.of(new Pair((Object)OptionalLong.of(alignTime), (Object)((TsPrimitiveType[])targetMeasurements.stream().map(targetMeasurement -> {
            if (!targetMeasurement.isEmpty()) {
                TimeValuePair tvPair = this.measurement2CachedLastMap.get(targetMeasurement);
                if (Objects.isNull(tvPair)) {
                    return null;
                }
                return tvPair.getTimestamp() == alignTime ? tvPair.getValue() : EMPTY_PRIMITIVE_TYPE;
            }
            return new TsPrimitiveType.TsLong(alignTime);
        }).toArray(TsPrimitiveType[]::new))));
    }

    int estimateSize() {
        return INSTANCE_SIZE + (int)RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY * this.measurement2CachedLastMap.size() + this.measurement2CachedLastMap.values().stream().mapToInt(TimeValuePair::getSize).reduce(0, Integer::sum);
    }

    private static int getDiffSize(TimeValuePair oldTimeValuePair, TimeValuePair newTimeValuePair) {
        if (oldTimeValuePair == EMPTY_TIME_VALUE_PAIR || oldTimeValuePair == PLACEHOLDER_TIME_VALUE_PAIR) {
            return newTimeValuePair.getSize();
        }
        TsPrimitiveType oldValue = oldTimeValuePair.getValue();
        TsPrimitiveType newValue = newTimeValuePair.getValue();
        if (oldValue == null) {
            return newValue == null ? 0 : newValue.getSize();
        }
        if (oldValue instanceof TsPrimitiveType.TsBinary) {
            return (newValue == null ? 0 : newValue.getSize()) - oldValue.getSize();
        }
        return newValue == null ? -oldValue.getSize() : 0;
    }
}

