/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;

class AggregationDecorrelation {
    private AggregationDecorrelation() {
    }

    public static boolean isDistinctOperator(PlanNode node) {
        return node instanceof AggregationNode && ((AggregationNode)node).getAggregations().isEmpty() && ((AggregationNode)node).getGroupingSetCount() == 1 && ((AggregationNode)node).hasNonEmptyGroupingSet();
    }

    public static Map<Symbol, AggregationNode.Aggregation> rewriteWithMasks(Map<Symbol, AggregationNode.Aggregation> aggregations, Map<Symbol, Symbol> masks) {
        ImmutableMap.Builder rewritten = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            rewritten.put((Object)symbol, (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), aggregation.getFilter(), aggregation.getOrderingScheme(), Optional.of(masks.get(symbol))));
        }
        return rewritten.buildOrThrow();
    }

    public static AggregationNode restoreDistinctAggregation(AggregationNode distinct, PlanNode source, List<Symbol> groupingKeys) {
        Preconditions.checkArgument((boolean)AggregationDecorrelation.isDistinctOperator(distinct));
        return new AggregationNode(distinct.getPlanNodeId(), source, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(groupingKeys), (List<Symbol>)ImmutableList.of(), distinct.getStep(), Optional.empty(), Optional.empty());
    }
}

