/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class TrimColumnTransformer
extends UnaryColumnTransformer {
    private final byte[] character;

    public TrimColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String characterStr) {
        super(returnType, childColumnTransformer);
        this.character = characterStr.getBytes();
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBinary(new Binary(TrimColumnTransformer.trim(currentValue, this.character)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBinary(new Binary(TrimColumnTransformer.trim(currentValue, this.character)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    public static byte[] trim(byte[] source, byte[] character) {
        int start;
        if (source.length == 0 || character.length == 0) {
            return source;
        }
        int end = source.length - 1;
        for (start = 0; start <= end && TrimColumnTransformer.isContain(character, source[start]); ++start) {
        }
        while (start <= end && TrimColumnTransformer.isContain(character, source[end])) {
            --end;
        }
        if (start > end) {
            return new byte[0];
        }
        byte[] result = new byte[end - start + 1];
        System.arraycopy(source, start, result, 0, end - start + 1);
        return result;
    }

    public static boolean isContain(byte[] character, byte target) {
        for (byte b : character) {
            if (b != target) continue;
            return true;
        }
        return false;
    }
}

