/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client.ainode;

import java.io.IOException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.ainode.rpc.thrift.IAINodeRPCService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.transport.TNonblockingTransport;

public class AsyncAINodeServiceClient
extends IAINodeRPCService.AsyncClient
implements ThriftClient {
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endPoint;
    private final ClientManager<TEndPoint, AsyncAINodeServiceClient> clientManager;

    public AsyncAINodeServiceClient(ThriftClientProperty property, TEndPoint endPoint, TAsyncClientManager tClientManager, ClientManager<TEndPoint, AsyncAINodeServiceClient> clientManager) throws IOException {
        super(property.getProtocolFactory(), tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endPoint.getIp(), (int)endPoint.getPort(), (int)property.getConnectionTimeoutMs()));
        this.setTimeout(property.getConnectionTimeoutMs());
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endPoint = endPoint;
        this.clientManager = clientManager;
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        ThriftClient.resolveException((Throwable)e, (ThriftClient)this);
        this.returnSelf();
    }

    public void invalidate() {
        if (!this.hasError()) {
            super.onError(new Exception("This client has been invalidated"));
        }
    }

    public void invalidateAll() {
        this.clientManager.clear((Object)this.endPoint);
    }

    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    private void returnSelf() {
        this.clientManager.returnClient((Object)this.endPoint, (Object)this);
    }

    private void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            if (this.printLogWhenEncounterException) {
                logger.error("Unexpected exception occurs in {} : {}", (Object)this, (Object)e.getMessage());
            }
            return false;
        }
    }

    public static class Factory
    extends AsyncThriftClientFactory<TEndPoint, AsyncAINodeServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncAINodeServiceClient> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
            super(clientManager, thriftClientProperty, threadName);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncAINodeServiceClient> pooledObject) {
            ((AsyncAINodeServiceClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<AsyncAINodeServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            return new DefaultPooledObject((Object)new AsyncAINodeServiceClient(this.thriftClientProperty, endPoint, this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length], (ClientManager<TEndPoint, AsyncAINodeServiceClient>)this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncAINodeServiceClient> pooledObject) {
            return ((AsyncAINodeServiceClient)((Object)pooledObject.getObject())).isReady();
        }
    }
}

