/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;

public abstract class ConstraintDescriptor
extends UniqueTupleDescriptor
implements Provider,
Dependent {
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int ALL = 3;
    public static final int SYSCONSTRAINTS_STATE_FIELD = 6;
    TableDescriptor table;
    final String constraintName;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private boolean enforced;
    private final int[] referencedColumns;
    final UUID constraintId;
    private final SchemaDescriptor schemaDesc;
    private ColumnDescriptorList colDL;

    ConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, SchemaDescriptor schemaDescriptor, boolean bl3) {
        super(dataDictionary);
        this.table = tableDescriptor;
        this.constraintName = string;
        this.deferrable = bl;
        this.initiallyDeferred = bl2;
        this.referencedColumns = nArray;
        this.constraintId = uUID;
        this.schemaDesc = schemaDescriptor;
        this.enforced = bl3;
    }

    public UUID getTableId() {
        return this.table.getUUID();
    }

    @Override
    public UUID getUUID() {
        return this.constraintId;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public abstract int getConstraintType();

    public abstract UUID getConglomerateId();

    public String getConstraintText() {
        return null;
    }

    public boolean deferrable() {
        return this.deferrable;
    }

    public void setDeferrable(boolean bl) {
        this.deferrable = bl;
    }

    public boolean initiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(boolean bl) {
        this.initiallyDeferred = bl;
    }

    public int[] getReferencedColumns() {
        return ArrayUtil.copy((int[])this.referencedColumns);
    }

    public abstract boolean hasBackingIndex();

    public SchemaDescriptor getSchemaDescriptor() {
        return this.schemaDesc;
    }

    public int[] getKeyColumns() {
        return this.getReferencedColumns();
    }

    public boolean enforced() {
        return this.enforced;
    }

    public void setEnforced(boolean bl) {
        this.enforced = bl;
    }

    public boolean isReferenced() {
        return false;
    }

    public int getReferenceCount() {
        return 0;
    }

    public abstract boolean needsToFire(int var1, int[] var2);

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public ColumnDescriptorList getColumnDescriptors() throws StandardException {
        if (this.colDL == null) {
            this.colDL = new ColumnDescriptorList();
            int[] nArray = this.getReferencedColumns();
            for (int i = 0; i < nArray.length; ++i) {
                this.colDL.add(this.table.getColumnDescriptor(nArray[i]));
            }
        }
        return this.colDL;
    }

    public boolean areColumnsComparable(ColumnDescriptorList columnDescriptorList) throws StandardException {
        int n;
        ColumnDescriptorList columnDescriptorList2 = this.getColumnDescriptors();
        if (columnDescriptorList.size() != columnDescriptorList2.size()) {
            return false;
        }
        int n2 = columnDescriptorList2.size();
        int n3 = columnDescriptorList.size();
        for (n = 0; n < n2 && n < n3; ++n) {
            ColumnDescriptor columnDescriptor = columnDescriptorList2.elementAt(n);
            ColumnDescriptor columnDescriptor2 = columnDescriptorList.elementAt(n);
            if (!columnDescriptor.getType().isExactTypeAndLengthMatch(columnDescriptor2.getType())) break;
        }
        return n == n2 && n == n3;
    }

    public boolean columnIntersects(int[] nArray) {
        return ConstraintDescriptor.doColumnsIntersect(this.getReferencedColumns(), nArray);
    }

    static boolean doColumnsIntersect(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return true;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray2[i] != nArray[j]) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(208);
    }

    @Override
    public String getObjectName() {
        return this.constraintName;
    }

    @Override
    public UUID getObjectID() {
        return this.constraintId;
    }

    @Override
    public String getClassType() {
        return "Constraint";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        switch (n) {
            case 20: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 34: 
            case 44: 
            case 47: 
            case 48: {
                break;
            }
            default: {
                throw StandardException.newException((String)"X0Y25.S", (Object[])new Object[]{dependencyManager.getActionString(n), provider.getObjectName(), "CONSTRAINT", this.constraintName});
            }
        }
    }

    @Override
    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (n == 44 || n == 47) {
            ConglomerateDescriptor conglomerateDescriptor = this.drop(languageConnectionContext, true);
            this.getDataDictionary().getDependencyManager().invalidateFor(this.table, 12, languageConnectionContext);
            languageConnectionContext.getLastActivation().addWarning(StandardException.newWarning((String)"01500", (Object[])new Object[]{this.getConstraintName(), this.getTableDescriptor().getName()}));
            if (conglomerateDescriptor != null) {
                // empty if block
            }
            return;
        }
        if (n == 21 || n == 20 || n == 29 || n == 30 || n == 23 || n == 48 || n != 34) {
            // empty if block
        }
    }

    public ConglomerateDescriptor drop(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        Object object;
        DataDictionary dataDictionary = this.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        if (bl) {
            object = dataDictionary.getDependencyManager();
            object.clearDependencies(languageConnectionContext, this);
        }
        dataDictionary.dropConstraintDescriptor(this, transactionController);
        object = null;
        if (this.hasBackingIndex()) {
            ConglomerateDescriptor[] conglomerateDescriptorArray;
            for (ConglomerateDescriptor conglomerateDescriptor : conglomerateDescriptorArray = dataDictionary.getConglomerateDescriptors(this.getConglomerateId())) {
                if (!conglomerateDescriptor.isConstraint()) continue;
                object = conglomerateDescriptor.drop(languageConnectionContext, this.table);
                break;
            }
        }
        this.table.removeConstraintDescriptor(this);
        return object;
    }

    @Override
    public String getDescriptorName() {
        return this.constraintName;
    }

    @Override
    public String getDescriptorType() {
        return "Constraint";
    }
}

