/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.dlp;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.api.DLPRules;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.transport.matchers.dlp.DlpDomainRules;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface DlpRulesLoader {
    public DlpDomainRules load(Domain var1);

    public static class Caching
    implements DlpRulesLoader {
        private final LoadingCache<Domain, DlpDomainRules> cache;

        public Caching(final DlpRulesLoader wrapped, GaugeRegistry gaugeRegistry, Duration cacheDuration) {
            this.cache = CacheBuilder.newBuilder().expireAfterWrite(cacheDuration).recordStats().build((CacheLoader)new CacheLoader<Domain, DlpDomainRules>(this){

                public DlpDomainRules load(Domain domain) {
                    return wrapped.load(domain);
                }
            });
            gaugeRegistry.register("dlp.cache.hitRate", () -> this.cache.stats().hitRate());
            gaugeRegistry.register("dlp.cache.missCount", () -> this.cache.stats().missCount());
            gaugeRegistry.register("dlp.cache.hitCount", () -> this.cache.stats().hitCount());
            gaugeRegistry.register("dlp.cache.size", () -> this.cache.size());
        }

        @Override
        public DlpDomainRules load(Domain domain) {
            try {
                return (DlpDomainRules)this.cache.get((Object)domain);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Impl
    implements DlpRulesLoader {
        private final DLPConfigurationStore configurationStore;

        @Inject
        public Impl(DLPConfigurationStore configurationStore) {
            this.configurationStore = configurationStore;
        }

        @Override
        public DlpDomainRules load(Domain domain) {
            return this.toRules((DLPRules)Mono.from((Publisher)this.configurationStore.list(domain)).block());
        }

        private DlpDomainRules toRules(DLPRules items) {
            DlpDomainRules.DlpDomainRulesBuilder builder = DlpDomainRules.builder();
            items.forEach(item -> item.getTargets().list().forEach(type -> builder.rule((DLPConfigurationItem.Targets.Type)type, item.getId(), item.getRegexp())));
            return builder.build();
        }
    }
}

