/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.SnowballLanguage;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class SnowballTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final SnowballLanguage language;
    public static final JsonpDeserializer<SnowballTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnowballTokenFilter::setupSnowballTokenFilterDeserializer);

    private SnowballTokenFilter(Builder builder) {
        super(builder);
        this.language = ApiTypeHelper.requireNonNull(builder.language, this, "language");
    }

    public static SnowballTokenFilter of(Function<Builder, ObjectBuilder<SnowballTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Snowball;
    }

    public final SnowballLanguage language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "snowball");
        super.serializeInternal(generator, mapper);
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
    }

    protected static void setupSnowballTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, SnowballLanguage._DESERIALIZER, "language");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SnowballTokenFilter> {
        private SnowballLanguage language;

        public final Builder language(SnowballLanguage value) {
            this.language = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnowballTokenFilter build() {
            this._checkSingleUse();
            return new SnowballTokenFilter(this);
        }
    }
}

