/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.ModifiedUtf7;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.LsubRequest;
import org.apache.james.imap.message.response.LSubResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.PrefixedRegex;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class LSubProcessor
extends AbstractMailboxProcessor<LsubRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LSubProcessor.class);
    public static final boolean RELATIVE = true;
    private final SubscriptionManager subscriptionManager;
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public LSubProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(LsubRequest.class, mailboxManager, factory, metricFactory);
        this.subscriptionManager = subscriptionManager;
        this.pathConverterFactory = pathConverterFactory;
    }

    @Override
    protected Mono<Void> processRequestReactive(LsubRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String referenceName = request.getBaseReferenceName();
        String mailboxPattern = request.getMailboxPattern();
        return this.listSubscriptions(session, responder, referenceName, mailboxPattern).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_LSUB_FAILURE);
            return ReactorUtils.logAsMono(() -> LOGGER.error("LSub failed for reference {} and pattern {}", new Object[]{referenceName, mailboxPattern, e}));
        }).then();
    }

    private Mono<Void> listSubscriptions(ImapSession session, ImapProcessor.Responder responder, String referenceName, String mailboxName) {
        MailboxSession mailboxSession = session.getMailboxSession();
        try {
            PathConverter pathConverter = this.pathConverterFactory.forSession(session);
            Mono mailboxesMono = Flux.from((Publisher)this.subscriptionManager.subscriptionsReactive(mailboxSession)).handle((path, sink) -> pathConverter.mailboxName(true, (MailboxPath)path, mailboxSession).ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0))).collectList();
            String decodedMailName = ModifiedUtf7.decodeModifiedUTF7(referenceName);
            PrefixedRegex expression = new PrefixedRegex(decodedMailName, ModifiedUtf7.decodeModifiedUTF7(mailboxName), mailboxSession.getPathDelimiter());
            return mailboxesMono.doOnNext(arg_0 -> this.lambda$listSubscriptions$4(responder, (MailboxNameExpression)expression, mailboxSession, arg_0)).then();
        }
        catch (SubscriptionException e) {
            throw new RuntimeException(e);
        }
    }

    private void respond(ImapProcessor.Responder responder, MailboxNameExpression expression, String mailboxName, boolean originalSubscription, Collection<String> mailboxes, Collection<String> mailboxResponses, char delimiter) {
        if (expression.isExpressionMatch(mailboxName)) {
            if (!mailboxResponses.contains(mailboxName)) {
                responder.respond(new LSubResponse(mailboxName, !originalSubscription, delimiter));
                mailboxResponses.add(mailboxName);
            }
        } else {
            String parentMailbox;
            int lastDelimiter = mailboxName.lastIndexOf(delimiter);
            if (lastDelimiter > 0 && !mailboxes.contains(parentMailbox = mailboxName.substring(0, lastDelimiter))) {
                this.respond(responder, expression, parentMailbox, false, mailboxes, mailboxResponses, delimiter);
            }
        }
    }

    @Override
    protected MDCBuilder mdc(LsubRequest request) {
        return MDCBuilder.create().addToContext("action", "LSUB").addToContext("base", request.getBaseReferenceName()).addToContext("pattern", request.getMailboxPattern());
    }

    private /* synthetic */ void lambda$listSubscriptions$4(ImapProcessor.Responder responder, MailboxNameExpression expression, MailboxSession mailboxSession, List mailboxes) {
        ArrayList<String> mailboxResponses = new ArrayList<String>();
        for (String mailbox : mailboxes) {
            this.respond(responder, expression, mailbox, true, mailboxes, mailboxResponses, mailboxSession.getPathDelimiter());
        }
    }
}

