/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions.box;

import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.geosparql.spatial.property_functions.box.GenericSpatialGeomBoxPropertyFunction;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class IntersectBoxGeomPF
extends GenericSpatialGeomBoxPropertyFunction {
    @Override
    protected boolean checkSecondFilter(SpatialArguments spatialArguments, GeometryWrapper targetGeometryWrapper) {
        GeometryWrapper geometryWrapper = spatialArguments.getGeometryWrapper();
        try {
            return geometryWrapper.intersects(targetGeometryWrapper);
        }
        catch (MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage() + ": " + String.valueOf(targetGeometryWrapper.asLiteral()) + ", " + String.valueOf(geometryWrapper.asLiteral()), ex);
        }
    }
}

