/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.util.FileUtils;

public class RDFLanguages {
    public static final String strLangRDFXML = "RDF/XML";
    public static final String strLangTurtle = "Turtle";
    public static final String strLangNTriples = "N-Triples";
    public static final String strLangN3 = "N3";
    public static final String strLangRDFJSON = "RDF/JSON";
    public static final String strLangJSONLD = "JSON-LD";
    public static final String strLangNQuads = "N-Quads";
    public static final String strLangTriG = "TriG";
    public static final String strLangCSV = "CSV";
    public static final String strLangTSV = "TSV";
    public static final String strLangTriX = "TriX";
    public static final String strLangRDFPROTO = "RDF-PROTO";
    public static final String strLangRDFTHRIFT = "RDF-THRIFT";
    public static final Lang RDFXML = LangBuilder.create("RDF/XML", "application/rdf+xml").addAltNames("RDFXML").addAltNames("RDF/XML-ABBREV", "RDFXML-ABBREV").addAltNames("rdfxml").addFileExtensions("rdf", "owl", "xml").build();
    public static final Lang TURTLE;
    public static final Lang TTL;
    public static final Lang N3;
    public static final Lang NTRIPLES;
    public static final Lang NT;
    public static final Lang JSONLD;
    public static final String strLangJSONLD11 = "JSON-LD-11";
    public static final Lang JSONLD11;
    public static final Lang RDFJSON;
    public static final Lang TRIG;
    public static final Lang NQUADS;
    public static final Lang NQ;
    public static final Lang RDFPROTO;
    public static final Lang RDFTHRIFT;
    public static final Lang TEXT;
    public static final Lang TRIX;
    public static final Lang RDFNULL;
    public static final Lang RDFRAW;
    public static final Lang SHACLC;
    private static Map<String, Lang> mapLabelToLang;
    private static Map<String, Lang> mapContentTypeToLang;
    private static Map<String, Lang> mapFileExtToLang;

    public static Collection<Lang> getRegisteredLanguages() {
        return Set.copyOf(mapLabelToLang.values());
    }

    public static void init() {
    }

    private static synchronized void init$() {
        RDFLanguages.initStandard();
        Lang.RDFXML = RDFXML;
        Lang.NTRIPLES = NTRIPLES;
        Lang.NT = NT;
        Lang.N3 = N3;
        Lang.TURTLE = TURTLE;
        Lang.TTL = TTL;
        Lang.JSONLD = JSONLD;
        Lang.JSONLD11 = JSONLD11;
        Lang.RDFJSON = RDFJSON;
        Lang.NQUADS = NQUADS;
        Lang.NQ = NQ;
        Lang.TRIG = TRIG;
        Lang.RDFPROTO = RDFPROTO;
        Lang.RDFTHRIFT = RDFTHRIFT;
        Lang.TRIX = TRIX;
        Lang.RDFNULL = RDFNULL;
        Lang.RDFRAW = RDFRAW;
        Lang.SHACLC = SHACLC;
        Lang.CSV = LangBuilder.create(strLangCSV, "text/csv").addAltNames("csv").addFileExtensions("csv").build();
        Lang.TSV = LangBuilder.create(strLangTSV, "text/tab-separated-values").addAltNames("tsv").addFileExtensions("tsv").build();
    }

    private static void initStandard() {
        RDFLanguages.register(RDFXML);
        RDFLanguages.register(TURTLE);
        RDFLanguages.register(N3);
        RDFLanguages.register(NTRIPLES);
        RDFLanguages.register(JSONLD);
        RDFLanguages.register(JSONLD11);
        RDFLanguages.register(RDFJSON);
        RDFLanguages.register(TRIG);
        RDFLanguages.register(NQUADS);
        RDFLanguages.register(RDFPROTO);
        RDFLanguages.register(RDFTHRIFT);
        RDFLanguages.register(TRIX);
        RDFLanguages.register(RDFNULL);
        RDFLanguages.register(RDFRAW);
        RDFLanguages.register(SHACLC);
    }

    public static void register(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("null for language");
        }
        if (RDFLanguages.isMimeTypeRegistered(lang)) {
            Lang prev = RDFLanguages.contentTypeToLang(lang.getContentType());
            if (prev == null) {
                throw new IllegalStateException("Expect to find '" + String.valueOf(lang.getContentType()) + "'");
            }
            RDFLanguages.unregister(prev);
        }
        RDFLanguages.checkRegistration(lang);
        mapLabelToLang.put(RDFLanguages.canonicalKey(lang.getLabel()), lang);
        for (String altName : lang.getAltNames()) {
            mapLabelToLang.put(RDFLanguages.canonicalKey(altName), lang);
        }
        mapContentTypeToLang.put(RDFLanguages.canonicalKey(lang.getContentType().getContentTypeStr()), lang);
        for (String ct : lang.getAltContentTypes()) {
            mapContentTypeToLang.put(RDFLanguages.canonicalKey(ct), lang);
        }
        for (String ext : lang.getFileExtensions()) {
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            mapFileExtToLang.put(RDFLanguages.canonicalKey(ext), lang);
        }
    }

    private static boolean isMimeTypeRegistered(Lang lang) {
        if (lang == null) {
            return false;
        }
        String mimeType = RDFLanguages.canonicalKey(lang.getHeaderString());
        return mapContentTypeToLang.containsKey(mimeType);
    }

    private static void checkRegistration(Lang lang) {
        String cKey;
        if (lang == null) {
            return;
        }
        String label = RDFLanguages.canonicalKey(lang.getLabel());
        Lang existingRegistration = mapLabelToLang.get(label);
        if (existingRegistration == null) {
            return;
        }
        if (lang.equals(existingRegistration)) {
            return;
        }
        if (RDFLanguages.isMimeTypeRegistered(lang)) {
            String contentType = lang.getContentType().getContentTypeStr();
            RDFLanguages.error("Language overlap: " + String.valueOf(lang) + " and " + String.valueOf(mapContentTypeToLang.get(contentType)) + " on content type " + contentType);
            return;
        }
        for (String altName : lang.getAltNames()) {
            cKey = RDFLanguages.canonicalKey(altName);
            if (!mapLabelToLang.containsKey(cKey)) continue;
            RDFLanguages.error("Language overlap: " + String.valueOf(lang) + " and " + String.valueOf(mapLabelToLang.get(cKey)) + " on name " + altName);
        }
        for (String ct : lang.getAltContentTypes()) {
            cKey = RDFLanguages.canonicalKey(ct);
            if (!mapContentTypeToLang.containsKey(cKey)) continue;
            RDFLanguages.error("Language overlap: " + String.valueOf(lang) + " and " + String.valueOf(mapContentTypeToLang.get(cKey)) + " on content type " + ct);
        }
        for (String ext : lang.getFileExtensions()) {
            cKey = RDFLanguages.canonicalKey(ext);
            if (!mapFileExtToLang.containsKey(cKey)) continue;
            RDFLanguages.error("Language overlap: " + String.valueOf(lang) + " and " + String.valueOf(mapFileExtToLang.get(cKey)) + " on file extension type " + ext);
        }
    }

    public static void unregister(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("null for language");
        }
        mapLabelToLang.remove(RDFLanguages.canonicalKey(lang.getLabel()));
        mapContentTypeToLang.remove(RDFLanguages.canonicalKey(lang.getContentType().getContentTypeStr()));
        for (String altName : lang.getAltNames()) {
            mapLabelToLang.remove(RDFLanguages.canonicalKey(altName));
        }
        for (String ct : lang.getAltContentTypes()) {
            mapContentTypeToLang.remove(RDFLanguages.canonicalKey(ct));
        }
        for (String ext : lang.getFileExtensions()) {
            mapFileExtToLang.remove(RDFLanguages.canonicalKey(ext));
        }
    }

    public static boolean isRegistered(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("null for language");
        }
        String label = RDFLanguages.canonicalKey(lang.getLabel());
        Lang lang2 = mapLabelToLang.get(label);
        return lang2 != null;
    }

    public static boolean isTriples(Lang lang) {
        return RDFParserRegistry.isTriples(lang);
    }

    public static boolean isQuads(Lang lang) {
        return RDFParserRegistry.isQuads(lang);
    }

    public static boolean hasRegisteredParser(Lang lang) {
        return RDFParserRegistry.isRegistered(lang);
    }

    public static Lang contentTypeToLang(String contentType) {
        if (contentType == null) {
            return null;
        }
        String key = RDFLanguages.canonicalKey(contentType);
        return mapContentTypeToLang.get(key);
    }

    public static Lang contentTypeToLang(ContentType ct) {
        if (ct == null) {
            return null;
        }
        String key = RDFLanguages.canonicalKey(ct.getContentTypeStr());
        return mapContentTypeToLang.get(key);
    }

    public static String getCharsetForContentType(String contentType) {
        MediaType ct = MediaType.create(contentType);
        if (ct.getCharset() != null) {
            return ct.getCharset();
        }
        String mt = ct.getContentTypeStr();
        if ("application/n-triples".equals(mt)) {
            return "utf-8";
        }
        if ("text/plain".equals(mt)) {
            return "ascii";
        }
        if ("application/n-quads".equals(mt)) {
            return "utf-8";
        }
        if ("text/n-quads".equals(mt)) {
            return "ascii";
        }
        return "utf-8";
    }

    public static Lang shortnameToLang(String label) {
        if (label == null) {
            return null;
        }
        String key = RDFLanguages.canonicalKey(label);
        return mapLabelToLang.get(key);
    }

    public static Lang fileExtToLang(String ext) {
        if (ext == null) {
            return null;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        ext = RDFLanguages.canonicalKey(ext);
        return mapFileExtToLang.get(ext);
    }

    public static Lang resourceNameToLang(String resourceName) {
        return RDFLanguages.pathnameToLang(resourceName);
    }

    public static Lang resourceNameToLang(String resourceName, Lang dftLang) {
        return RDFLanguages.filenameToLang(resourceName, dftLang);
    }

    public static Lang filenameToLang(String uriOrFilename) {
        return RDFLanguages.pathnameToLang(uriOrFilename);
    }

    public static Lang pathnameToLang(String pathname) {
        if (pathname == null) {
            return null;
        }
        int iHash = pathname.indexOf(35);
        if (iHash > 0) {
            pathname = pathname.substring(0, iHash);
        }
        pathname = IO.filenameNoCompression(pathname);
        return RDFLanguages.fileExtToLang(FileUtils.getFilenameExt(pathname));
    }

    public static Lang filenameToLang(String filename, Lang dftLang) {
        Lang lang = RDFLanguages.pathnameToLang(filename);
        return lang == null ? dftLang : lang;
    }

    public static Lang nameToLang(String langName) {
        if (langName == null) {
            return null;
        }
        Lang lang = RDFLanguages.shortnameToLang(langName);
        if (lang != null) {
            return lang;
        }
        lang = RDFLanguages.contentTypeToLang(langName);
        return lang;
    }

    private static String canonicalKey(String x) {
        return Lib.lowercase(x);
    }

    public static ContentType guessContentType(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Lang lang = RDFLanguages.pathnameToLang(resourceName);
        if (lang == null) {
            return null;
        }
        return lang.getContentType();
    }

    private static void error(String message) {
        throw new RiotException(message);
    }

    public static boolean sameLang(Lang lang1, Lang lang2) {
        if (lang1 == null || lang2 == null) {
            return false;
        }
        if (lang1 == lang2) {
            return true;
        }
        return lang1.getLabel() == lang2.getLabel();
    }

    static {
        TTL = TURTLE = LangBuilder.create(strLangTurtle, "text/turtle").addAltNames("TTL").addAltContentTypes("application/turtle").addFileExtensions("ttl").build();
        N3 = LangBuilder.create(strLangN3, "text/rdf+n3").addAltContentTypes("text/rdf+n3", "application/n3", "text/n3").addFileExtensions("n3").build();
        NT = NTRIPLES = LangBuilder.create(strLangNTriples, "application/n-triples").addAltNames("NT", "NTriples", "NTriple", "N-Triple", strLangNTriples).addAltContentTypes("text/plain").addFileExtensions("nt").build();
        JSONLD = LangBuilder.create(strLangJSONLD, "application/ld+json").addAltNames("JSONLD").addFileExtensions("jsonld").build();
        JSONLD11 = LangBuilder.create(strLangJSONLD11, "x/ld-json-11").addAltNames("JSONLD11").addFileExtensions("jsonld11").build();
        RDFJSON = LangBuilder.create(strLangRDFJSON, "application/rdf+json").addAltNames("RDFJSON").addFileExtensions("rj").build();
        TRIG = LangBuilder.create(strLangTriG, "application/trig").addAltContentTypes("text/trig").addFileExtensions("trig").build();
        NQ = NQUADS = LangBuilder.create(strLangNQuads, "application/n-quads").addAltNames("NQ", "NQuads", "NQuad", "N-Quad", strLangNQuads).addAltContentTypes("text/n-quads").addFileExtensions("nq").build();
        RDFPROTO = LangBuilder.create(strLangRDFPROTO, "application/rdf+protobuf").addAltNames("RDF_PB", "RDFPB", "RDF/PB", "PBRDF").addFileExtensions("rpb", "pbrdf").build();
        RDFTHRIFT = LangBuilder.create(strLangRDFTHRIFT, "application/rdf+thrift").addAltNames("RDF_THRIFT", "RDFTHRIFT", "RDF/THRIFT", "TRDF").addFileExtensions("rt", "trdf").build();
        TEXT = LangBuilder.create("text", "text/plain").addAltNames("TEXT").addFileExtensions("txt").build();
        TRIX = LangBuilder.create(strLangTriX, "application/trix").addAltContentTypes("application/trix+xml").addAltNames("TRIX", "trix").addFileExtensions("trix").build();
        RDFNULL = LangBuilder.create("rdf/null", "null/rdf").addAltNames("NULL", "null").build();
        RDFRAW = LangBuilder.create("rdf/raw", "rdf/raw").addAltContentTypes("application/rdf+raw").addAltNames("raw", "dev").addFileExtensions("jena").build();
        SHACLC = LangBuilder.create("SHACLC", "text/shaclc").addAltNames("shaclc").addFileExtensions("shaclc", "shc").build();
        mapLabelToLang = new HashMap<String, Lang>();
        mapContentTypeToLang = new HashMap<String, Lang>();
        mapFileExtToLang = new HashMap<String, Lang>();
        RDFLanguages.init$();
    }
}

