/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;

abstract class SequenceVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 2544089499300079707L;
    final Class<? extends Number> type;
    final int length;

    SequenceVector(Class<? extends Number> type, int length) {
        this.type = type;
        this.length = length;
        if (length < 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "length", length));
        }
    }

    @Override
    final Vector createTransform(double scale, double offset) {
        return new Doubles(Double.class, Math.fma(this.doubleValue(0), scale, offset), this.increment(0.0).doubleValue() * scale, this.length);
    }

    @Override
    public final Class<? extends Number> getElementType() {
        return this.type;
    }

    @Override
    public final int size() {
        return this.length;
    }

    @Override
    public final boolean isEmptyOrNaN() {
        return this.length == 0 || this.isNaN(0);
    }

    @Override
    public final Number set(int index, Number value) {
        throw new UnsupportedOperationException(Errors.format((short)175, value));
    }

    @Override
    public final Vector compress(double tolerance) {
        return this;
    }

    @Override
    public double[] doubleValues() {
        if (this.increment(0.0).doubleValue() == 0.0) {
            double[] array = new double[this.size()];
            Arrays.fill(array, this.doubleValue(0));
            return array;
        }
        return super.doubleValues();
    }

    @Override
    public float[] floatValues() {
        if (this.increment(0.0).doubleValue() == 0.0) {
            float[] array = new float[this.size()];
            Arrays.fill(array, this.floatValue(0));
            return array;
        }
        return super.floatValues();
    }

    static class Doubles
    extends SequenceVector {
        private static final long serialVersionUID = -5222432536264284005L;
        private final double first;
        final double increment;

        Doubles(Class<? extends Number> type, Number first, Number increment, int length) {
            super(type, length);
            this.first = first.doubleValue();
            this.increment = increment.doubleValue();
        }

        @Override
        Vector createSubSampling(int offset, int step, int n) {
            return new Doubles(this.type, this.doubleValue(offset), this.increment * (double)step, n);
        }

        @Override
        public final boolean isInteger() {
            return Math.floor(this.first) == this.first && Math.floor(this.increment) == this.increment;
        }

        @Override
        public final boolean isNaN(int index) {
            return Double.isNaN(this.first) || Double.isNaN(this.increment);
        }

        @Override
        public final double doubleValue(int index) {
            ArgumentChecks.ensureValidIndex(this.length, index);
            return Math.fma((double)index, this.increment, this.first);
        }

        @Override
        public String stringValue(int index) {
            return String.valueOf(this.doubleValue(index));
        }

        @Override
        public Number get(int index) {
            return Numbers.wrap(this.doubleValue(index), this.type);
        }

        @Override
        public final Number increment(double tolerance) {
            return this.increment;
        }

        @Override
        public final NumberRange<?> range() {
            Number min2 = this.get(0);
            Number max2 = this.get(this.length - 1);
            if (((Comparable)((Object)max2)).compareTo((Comparable)((Object)min2)) < 0) {
                Number tmp = min2;
                min2 = max2;
                max2 = tmp;
            }
            return new NumberRange<Number>(this.type, min2, true, max2, true);
        }
    }

    static final class Longs
    extends SequenceVector {
        private static final long serialVersionUID = 8959308953555132379L;
        private final long first;
        private final long increment;

        Longs(Class<? extends Number> type, Number first, Number increment, int length) {
            super(type, length);
            this.first = first.longValue();
            this.increment = increment.longValue();
        }

        @Override
        Vector createSubSampling(int offset, int step, int n) {
            return new Longs(this.type, this.longValue(offset), this.increment * (long)step, n);
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        public boolean isNaN(int index) {
            return false;
        }

        @Override
        public double doubleValue(int index) {
            return this.longValue(index);
        }

        @Override
        public float floatValue(int index) {
            return this.longValue(index);
        }

        @Override
        public long longValue(int index) {
            ArgumentChecks.ensureValidIndex(this.length, index);
            return this.first + this.increment * (long)index;
        }

        @Override
        public String stringValue(int index) {
            return String.valueOf(this.longValue(index));
        }

        @Override
        public Number get(int index) {
            return Numbers.wrap(this.longValue(index), this.type);
        }

        @Override
        public Number increment(double tolerance) {
            return Numbers.wrap(this.increment, this.type);
        }

        @Override
        public NumberRange<?> range() {
            long max2 = this.first + this.increment * (long)(this.length - 1);
            long min2 = this.first;
            if (max2 < min2) {
                min2 = max2;
                max2 = this.first;
            }
            return new NumberRange(this.type, Numbers.wrap(min2, this.type), true, Numbers.wrap(max2, this.type), true);
        }
    }

    static final class Floats
    extends Doubles {
        private static final long serialVersionUID = 7972249253456554448L;

        Floats(Class<? extends Number> type, Number first, Number increment, int length) {
            super(type, first, increment, length);
        }

        @Override
        Vector createSubSampling(int offset, int step, int n) {
            return new Floats(this.type, this.doubleValue(offset), this.increment * (double)step, n);
        }

        @Override
        public Number get(int index) {
            return Float.valueOf(this.floatValue(index));
        }

        @Override
        public String stringValue(int index) {
            return String.valueOf(this.floatValue(index));
        }
    }
}

